module BV_SD_PINOUT(RXDI,CMND,PRM2,PRM1,CLK,LOBYTE,HIBYTE);

	//Port List 
	input     [7:0] RXDI;
	input     CMND;
	input     PRM2;
	input     PRM1;
	input     CLK;
	output    [7:0] LOBYTE;
	output    [7:0] HIBYTE;

	//Net List 
	wire      GND;
	wire      I31_O;
	wire      I32_O;

	//Lower module connection 
	GND Z1C0018(.G(GND));
	FD8CE Z1C0025(.Q(LOBYTE[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I31_O),.C(CLK));
	FD8CE Z1C0026(.Q(HIBYTE[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I32_O),.C(CLK));
	AND2 Z1C0031(.I0(PRM1),.I1(CMND),.O(I31_O));
	AND2 Z1C0032(.I0(PRM2),.I1(CMND),.O(I32_O));
endmodule 
