module BV_SD_SPCNT(READ_CE,R_ADR,TRGIN,ACQ_MODE,ACQMD_R,CMDI,RXDI,PRAM1,PRAM2,CLK,WE1,WE2,ADR,SPLX2_ACQ,SPLCE,SPL12,PHASEO,ACQMD_ON,SEL_BYTE,ACQ_RUN);

	//Port List 
	input     READ_CE;
	input     R_ADR;
	input     TRGIN;
	input     ACQ_MODE;
	input     ACQMD_R;
	input     CMDI;
	input     [7:0] RXDI;
	input     PRAM1;
	input     PRAM2;
	input     CLK;
	output    WE1;
	output    WE2;
	output    [10:0] ADR;
	output    SPLX2_ACQ;
	output    SPLCE;
	output    SPL12;
	output    PHASEO;
	output    ACQMD_ON;
	output    SEL_BYTE;
	output    ACQ_RUN;

	//Net List 
	wire      I39_O;
	wire      I83_CNT_RESET;
	wire      I4_CEO;
	wire      I11_ADRS_CE;
	wire      GND;
	wire      VCC;
	wire      I18_O;
	wire      [7:0] I29_SPLQ;
	wire      SPLCE1;
	wire      I36_O;
	wire      I80_ACQ_ST;
	wire      [7:0] I22_Q;
	wire      SPLX2;
	wire      I42_WRCE;
	wire      I51_CEO;
	wire      I53_O;
	wire      I55_O;
	wire      [7:0] I65_Q;
	wire      [7:0] I131_O;
	wire      I64_EQ_STOP;
	wire      I69_O;
	wire      I88_TRGIN_AFT;
	wire      I66_TRGACK;
	wire      I153_TRGACK2;
	wire      I74_O;
	wire      I94_ACQ_DLY;
	wire      I79_Q;
	wire      I85_TURN_ALL;
	wire      [11:0] I124_Q;
	wire      SPLCEX;
	wire      SPLX1;

	//Lower module connection 
	CB1RE Z1C0004(.CE(I39_O),.CK(CLK),.R(I83_CNT_RESET),.Q0(SEL_BYTE),.CEO(I4_CEO));
	OR2 Z1C0011(.I0(SPLX2_ACQ),.I1(I4_CEO),.O(I11_ADRS_CE));
	GND Z1C0014(.G(GND));
	VCC Z1C0016(.P(VCC));
	AND2 Z1C0018(.I0(PRAM1),.I1(CMDI),.O(I18_O));
	FD8CE Z1C0022(.Q(I22_Q[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I18_O),.C(CLK));
	COMP8 Z1C0026(.B(I22_Q[7:0]),.A(I29_SPLQ[7:0]),.EQ(SPLCE1));
	CB8RE Z1C0029(.Q(I29_SPLQ[7:0]),.C(CLK),.R(I36_O),.CE(VCC));
	OR2 Z1C0036(.I0(I80_ACQ_ST),.I1(SPLCE1),.O(I36_O));
	AND8 Z1C0037(.I0(I22_Q[7]),.I1(I22_Q[6]),.I2(I22_Q[5]),.I3(I22_Q[4]),.I4(I22_Q[3]),.I5(I22_Q[2]),.I6(I22_Q[1]),.I7(I22_Q[0]),.O(SPLX2));
	M2_1 Z1C0039(.D0(READ_CE),.D1(I42_WRCE),.O(I39_O),.S0(ACQMD_ON));
	AND2 Z1C0042(.I0(SPLCE),.I1(ACQ_RUN),.O(I42_WRCE));
	AND2 Z1C0045(.I0(SPLX2),.I1(ACQ_RUN),.O(SPLX2_ACQ));
	CB11RE Z1C0051(.Q(ADR[10:0]),.C(CLK),.R(I83_CNT_RESET),.CE(I11_ADRS_CE),.CEO(I51_CEO));
	AND3 Z1C0053(.I0(SEL_BYTE),.I1(I39_O),.I2(ACQ_RUN),.O(I53_O));
	AND3B1 Z1C0055(.I0(SEL_BYTE),.I1(I39_O),.I2(ACQ_RUN),.O(I55_O));
	OR2 Z1C0056(.I0(SPLX2_ACQ),.I1(I55_O),.O(WE1));
	OR2 Z1C0057(.I0(SPLX2_ACQ),.I1(I53_O),.O(WE2));
	COMP8 Z1C0064(.B(I65_Q[7:0]),.A(I131_O[7:0]),.EQ(I64_EQ_STOP));
	FD8CE Z1C0065(.Q(I65_Q[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I69_O),.C(CLK));
	FDRE Z1C0066(.C(CLK),.CE(I88_TRGIN_AFT),.D(VCC),.Q(I66_TRGACK),.R(I80_ACQ_ST));
	defparam Z1C0066.INIT=1'b0;
	AND2 Z1C0069(.I0(PRAM2),.I1(CMDI),.O(I69_O));
	INV Z1C0074(.I(I153_TRGACK2),.O(I74_O));
	FDRE Z1C0079(.C(CLK),.CE(I94_ACQ_DLY),.D(VCC),.Q(I79_Q),.R(I64_EQ_STOP));
	defparam Z1C0079.INIT=1'b0;
	ONESHOT_D1 Z1C0080(.I(ACQ_MODE),.CK(CLK),.Q(I80_ACQ_ST));
	OR2 Z1C0083(.I0(I80_ACQ_ST),.I1(R_ADR),.O(I83_CNT_RESET));
	FDRE Z1C0085(.C(CLK),.CE(I51_CEO),.D(VCC),.Q(I85_TURN_ALL),.R(I83_CNT_RESET));
	defparam Z1C0085.INIT=1'b0;
	AND3 Z1C0091(.I0(I85_TURN_ALL),.I1(TRGIN),.I2(ACQMD_ON),.O(I88_TRGIN_AFT));
	DLY3 Z1C0094(.D(I80_ACQ_ST),.CK(CLK),.Q3(I94_ACQ_DLY));
	CB12RE Z1C0124(.Q(I124_Q[11:0]),.C(CLK),.R(I74_O),.CE(I42_WRCE));
	OR2 Z1C0128(.I0(SPLX2),.I1(SPLCE1),.O(SPLCEX));
	M2_1_8 Z1C0131(.A(I124_Q[11:4]),.B(I124_Q[10:3]),.O(I131_O[7:0]),.S0(SPLX2));
	OR8_BUS Z1C0147(.I(I22_Q[7:0]),.O(SPLX1));
	OR2B1 Z1C0148(.I0(SPLX1),.I1(SPLX2),.O(SPL12));
	FD Z1C0151(.Q(SPLCE),.D(SPLCEX),.C(CLK));
	defparam Z1C0151.INIT=1'b0;
	FDRE Z1C0153(.C(CLK),.CE(SPLCE),.D(I66_TRGACK),.Q(I153_TRGACK2),.R(I80_ACQ_ST));
	defparam Z1C0153.INIT=1'b0;
	FDRE Z1C0156(.C(CLK),.CE(SPLCE),.D(I79_Q),.Q(ACQ_RUN),.R(GND));
	defparam Z1C0156.INIT=1'b0;
	AND2 Z1C0161(.I0(SPLX2),.I1(ADR[0]),.O(PHASEO));
	FDRE Z1C0175(.C(CLK),.CE(I80_ACQ_ST),.D(VCC),.Q(ACQMD_ON),.R(ACQMD_R));
	defparam Z1C0175.INIT=1'b0;
endmodule 
