module BV_SERIAL8(TBUS,TX_START,BOAURATE,RXI,CLK,TXO,TX_RUNO,TIMINGO,TX_BAU,RXDO,RX_OK,RX_BUSY,TIMEOUT);

	//Port List 
	input     [7:0] TBUS;
	input     TX_START;
	input     [7:0] BOAURATE;
	input     RXI;
	input     CLK;
	output    TXO;
	output    TX_RUNO;
	output    TIMINGO;
	output    TX_BAU;
	output    [7:0] RXDO;
	output    RX_OK;
	output    RX_BUSY;
	output    TIMEOUT;

	//Net List 
	wire      VCC;
	wire      TX_ST;
	wire      I21_O;
	wire      GND;
	wire      [9:0] XI1_D;
	wire      I32_O;
	wire      I18_Q0;
	wire      I18_Q1;
	wire      I18_Q2;
	wire      I18_Q3;
	wire      TX_CE;
	wire      I36_O;
	wire      I72_O;
	wire      [7:0] I43_Q;
	wire      I44_EQ;
	wire      I53_Q;
	wire      I54_Q;
	wire      I93_Q1;
	wire      [9:0] I63_G;
	wire      RX_CE2;
	wire      [9:0] I58_Q;
	wire      [7:0] I122_O;
	wire      I127_Q2;
	wire      [7:0] I136_Q;
	wire      [9:0] I1_Q;
	wire      [3:0] I84_Q;
	wire      I93_Q2;
	wire      BOTHEDGE;
	wire      [7:0] I98_Q;
	wire      I103_O;
	wire      I101_EQ;
	wire      [7:0] I107_O;
	wire      RX_CE;
	wire      NEGEDGE;
	wire      I125_O;
	wire      I120_O;
	wire      [3:0] I112_Q;
	wire      I127_Q1;
	wire      I132_O;

	//Lower module connection 
	SR10CLE Z1C0001(.SLI(VCC),.D(XI1_D[9:0]),.L(TX_ST),.CE(I21_O),.C(CLK),.CLR(GND),.Q(I1_Q[9:0]));
	BUF Z1C0003(.I(VCC),.O(XI1_D[0]));
	BUF Z1C0004(.I(GND),.O(XI1_D[9]));
	GND Z1C0005(.G(GND));
	VCC Z1C0006(.P(VCC));
	CB4RE Z1C0018(.CE(I32_O),.Q0(I18_Q0),.Q1(I18_Q1),.Q2(I18_Q2),.Q3(I18_Q3),.C(CLK),.R(TX_ST));
	AND2 Z1C0021(.I0(TX_RUNO),.I1(TX_CE),.O(I21_O));
	AND2B1 Z1C0032(.O(I32_O),.I1(TX_CE),.I0(I36_O));
	FDRE Z1C0035(.C(CLK),.CE(I72_O),.D(VCC),.Q(TX_RUNO),.R(I36_O));
	defparam Z1C0035.INIT=1'b0;
	AND2 Z1C0036(.I0(I18_Q3),.I1(I18_Q0),.O(I36_O));
	CB8RE Z1C0043(.Q(I43_Q[7:0]),.C(CLK),.R(I44_EQ),.CE(VCC));
	COMP8 Z1C0044(.B(BOAURATE[7:0]),.A(I43_Q[7:0]),.EQ(I44_EQ));
	FDRE Z1C0053(.C(CLK),.CE(TX_START),.D(VCC),.Q(I53_Q),.R(I54_Q));
	defparam Z1C0053.INIT=1'b0;
	FDRE Z1C0054(.C(CLK),.CE(TX_CE),.D(I53_Q),.Q(I54_Q),.R(GND));
	defparam Z1C0054.INIT=1'b0;
	SR10CLE Z1C0058(.SLI(I93_Q1),.D(I63_G[9:0]),.L(GND),.CE(RX_CE2),.C(CLK),.CLR(GND),.Q(I58_Q[9:0]));
	FD8CE Z1C0061(.Q(RXDO[7:0]),.D(I122_O[7:0]),.CLR(GND),.CE(I127_Q2),.C(CLK));
	GN10 Z1C0063(.G(I63_G[9:0]));
	AND2 Z1C0065(.I0(I36_O),.I1(I54_Q),.O(TX_ST));
	FD Z1C0067(.Q(TX_CE),.D(I44_EQ),.C(CLK));
	defparam Z1C0067.INIT=1'b0;
	BUF Z1C0070(.I(TX_CE),.O(TX_BAU));
	AND4B4 Z1C0072(.I0(I18_Q3),.I1(I18_Q2),.I2(I18_Q1),.I3(I18_Q0),.O(I72_O));
	BV_SWAP Z1C0080(.I(I136_Q[7:0]),.O(XI1_D[8:1]));
	BUF Z1C0083(.I(I1_Q[9]),.O(TXO));
	CB4RE_BUS Z1C0084(.Q(I84_Q[3:0]),.C(CLK),.R(TIMINGO),.CE(TX_CE));
	AND3 Z1C0086(.I0(TX_CE),.I1(I84_Q[3]),.I2(I84_Q[0]),.O(TIMINGO));
	XOR2 Z1C0091(.I0(I93_Q2),.I1(I93_Q1),.O(BOTHEDGE));
	DLY3 Z1C0093(.D(RXI),.CK(CLK),.Q2(I93_Q2),.Q1(I93_Q1));
	CB8RE Z1C0098(.Q(I98_Q[7:0]),.C(CLK),.R(I103_O),.CE(VCC));
	COMP8 Z1C0101(.B(BOAURATE[7:0]),.A(I98_Q[7:0]),.EQ(I101_EQ));
	OR2 Z1C0103(.I0(I101_EQ),.I1(BOTHEDGE),.O(I103_O));
	COMP8 Z1C0106(.B(I107_O[7:0]),.A(I98_Q[7:0]),.EQ(RX_CE));
	BIT_DN8 Z1C0107(.O(I107_O[7:0]),.I(BOAURATE[7:0]));
	AND2B1 Z1C0110(.O(NEGEDGE),.I1(I93_Q2),.I0(I93_Q1));
	CB4RE_BUS Z1C0112(.Q(I112_Q[3:0]),.C(CLK),.R(I125_O),.CE(RX_CE2));
	FDRE Z1C0113(.C(CLK),.CE(NEGEDGE),.D(VCC),.Q(RX_BUSY),.R(I120_O));
	defparam Z1C0113.INIT=1'b0;
	AND2 Z1C0115(.I0(RX_CE),.I1(RX_BUSY),.O(RX_CE2));
	AND2 Z1C0120(.I0(I112_Q[0]),.I1(I112_Q[3]),.O(I120_O));
	BV_SWAP Z1C0122(.I(I58_Q[7:0]),.O(I122_O[7:0]));
	AND2 Z1C0125(.I0(I120_O),.I1(RX_CE),.O(I125_O));
	DLY3 Z1C0127(.D(I120_O),.CK(CLK),.Q3(RX_OK),.Q2(I127_Q2),.Q1(I127_Q1));
	CB2RE Z1C0131(.TC(TIMEOUT),.CE(I132_O),.C(CLK),.R(I127_Q1));
	AND2B1 Z1C0132(.O(I132_O),.I1(TIMINGO),.I0(TIMEOUT));
	FD8CE Z1C0136(.Q(I136_Q[7:0]),.D(TBUS[7:0]),.CLR(GND),.CE(TX_START),.C(CLK));
endmodule 
