module RAMB16_D8(WEA,DIA,ADA,ENA,CKA,RSTA,CEA,WEB,DIB,ADB,ENB,CKB,RSTB,CEB,DOA,DOB);

	//Port List 
	input     WEA;
	input     [7:0] DIA;
	input     [10:0] ADA;
	input     ENA;
	input     CKA;
	input     RSTA;
	input     CEA;
	input     WEB;
	input     [7:0] DIB;
	input     [10:0] ADB;
	input     ENB;
	input     CKB;
	input     RSTB;
	input     CEB;
	output    [7:0] DOA;
	output    [7:0] DOB;

    wire  [15:0]  DOADO;
    wire  [1:0]   DOPADOP;
    wire  [15:0]  DOBDO;
    wire  [1:0]   DOPBDOP;
    wire  [13:0]  ADDRARDADDR;
   // wire    CLKARDCLK;
   // wire    ENARDEN;
   // wire    REGCEAREGCE;
   // wire    RSTRAMARSTRAM;
   // wire   RSTREGARSTREG;
    wire  [1:0]   WEAX;
    wire  [15:0]  DIADI;
    wire  [1:0]   DIPADIP;
    wire  [13:0]  ADDRBWRADDR;
 //   wire    CLKBWRCLK;
 //   wire    ENBWREN;
//    wire    REGCEB;
 //   wire    RSTRAMB;
 //   wire    RSTREGB;
    wire  [3:0]   WEBX;
    wire  [15:0]  DIBDI;
    wire  [1:0]   DIPBDIP;


RAMB18E1 #(
   // Address Collision Mode: "PERFORMANCE" or "DELAYED_WRITE"
   .RDADDR_COLLISION_HWCONFIG("DELAYED_WRITE"),
   // Collision check: Values ("ALL", "WARNING_ONLY", "GENERATE_X_ONLY" or "NONE")
   .SIM_COLLISION_CHECK("ALL"),
   // DOA_REG, DOB_REG: Optional output register (0 or 1)
   .DOA_REG(0),
   .DOB_REG(0),
   // INITP_00 to INITP_07: Initial contents of parity memory array
   .INITP_00(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_01(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_02(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_03(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_04(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_05(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_06(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_07(256'h0000000000000000000000000000000000000000000000000000000000000000),
   // INIT_00 to INIT_3F: Initial contents of data memory array
   .INIT_00(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_01(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_02(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_03(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_04(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_05(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_06(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_07(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_08(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_09(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_10(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_11(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_12(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_13(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_14(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_15(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_16(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_17(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_18(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_19(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_20(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_21(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_22(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_23(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_24(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_25(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_26(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_27(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_28(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_29(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_30(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_31(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_32(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_33(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_34(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_35(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_36(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_37(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_38(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_39(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   // INIT_A, INIT_B: Initial values on output ports
   .INIT_A(18'h00000),
   .INIT_B(18'h00000),
   // Initialization File: RAM initialization file
   .INIT_FILE("NONE"),
   // RAM Mode: "SDP" or "TDP"
   .RAM_MODE("TDP"),
   // READ_WIDTH_A/B, WRITE_WIDTH_A/B: Read/write width per port
   .READ_WIDTH_A(9),                                                                 // 0-72
   .READ_WIDTH_B(9),                                                                 // 0-18
   .WRITE_WIDTH_A(9),                                                                // 0-18
   .WRITE_WIDTH_B(9),                                                                // 0-72
   // RSTREG_PRIORITY_A, RSTREG_PRIORITY_B: Reset or enable priority ("RSTREG" or "REGCE")
   .RSTREG_PRIORITY_A("RSTREG"),
   .RSTREG_PRIORITY_B("RSTREG"),
   // SRVAL_A, SRVAL_B: Set/reset value for output
   .SRVAL_A(18'h00000),
   .SRVAL_B(18'h00000),
   // Simulation Device: Must be set to "7SERIES" for simulation behavior
   .SIM_DEVICE("7SERIES"),
   // WriteMode: Value on output upon a write ("WRITE_FIRST", "READ_FIRST", or "NO_CHANGE")
   .WRITE_MODE_A("READ_FIRST"),
   .WRITE_MODE_B("READ_FIRST")
)
RAMB18E1_inst (
   // Port A Data: 16-bit (each) output: Port A data
   .DOADO(DOADO),                 // 16-bit output: A port data/LSB data
   .DOPADOP(DOPADOP),             // 2-bit output: A port parity/LSB parity
   // Port B Data: 16-bit (each) output: Port B data
   .DOBDO(DOBDO),                 // 16-bit output: B port data/MSB data
   .DOPBDOP(DOPBDOP),             // 2-bit output: B port parity/MSB parity
   // Port A Address/Control Signals: 14-bit (each) input: Port A address and control signals (read port
   // when RAM_MODE="SDP")
   .ADDRARDADDR(ADDRARDADDR),     // 14-bit input: A port address/Read address
   .CLKARDCLK(CKA),         // 1-bit input: A port clock/Read clock
   .ENARDEN(ENA),             // 1-bit input: A port enable/Read enable
   .REGCEAREGCE(CEA),     // 1-bit input: A port register enable/Register enable
   .RSTRAMARSTRAM(RSTA), // 1-bit input: A port set/reset
   .RSTREGARSTREG(RSTA), // 1-bit input: A port register set/reset
   .WEA(WEAX),                     // 2-bit input: A port write enable
   // Port A Data: 16-bit (each) input: Port A data
   .DIADI(DIADI),                 // 16-bit input: A port data/LSB data
   .DIPADIP(DIPADIP),             // 2-bit input: A port parity/LSB parity
   // Port B Address/Control Signals: 14-bit (each) input: Port B address and control signals (write port
   // when RAM_MODE="SDP")
   .ADDRBWRADDR(ADDRBWRADDR),     // 14-bit input: B port address/Write address
   .CLKBWRCLK(CKB),         // 1-bit input: B port clock/Write clock
   .ENBWREN(ENB),             // 1-bit input: B port enable/Write enable
   .REGCEB(CEB),               // 1-bit input: B port register enable
   .RSTRAMB(RSTB),             // 1-bit input: B port set/reset
   .RSTREGB(RSTB),             // 1-bit input: B port register set/reset
   .WEBWE(WEBX),                 // 4-bit input: B port write enable/Write enable
   // Port B Data: 16-bit (each) input: Port B data
   .DIBDI(DIBDI),                 // 16-bit input: B port data/MSB data
   .DIPBDIP(DIPBDIP)              // 2-bit input: B port parity/MSB parity
);

// End of RAMB18E1_inst instantiation
    assign WEAX[0]=WEA;
    assign WEAX[1]=WEA;
    assign WEBX[0]=WEB;
    assign WEBX[1]=WEB;
    assign WEBX[2]=WEB;
    assign WEBX[3]=WEB;

    assign  DOA[0]=DOADO[0];
    assign  DOA[1]=DOADO[1];
    assign  DOA[2]=DOADO[2];
    assign  DOA[3]=DOADO[3];
    assign  DOA[4]=DOADO[4];
    assign  DOA[5]=DOADO[5];
    assign  DOA[6]=DOADO[6];
    assign  DOA[7]=DOADO[7];

    assign DOB[0]=DOBDO[0];
    assign DOB[1]=DOBDO[1];
    assign DOB[2]=DOBDO[2];
    assign DOB[3]=DOBDO[3];
    assign DOB[4]=DOBDO[4];
    assign DOB[5]=DOBDO[5];
    assign DOB[6]=DOBDO[6];
    assign DOB[7]=DOBDO[7];

    assign  DIADI[0]=DIA[0];
    assign  DIADI[1]=DIA[1];
    assign  DIADI[2]=DIA[2];
    assign  DIADI[3]=DIA[3];
    assign  DIADI[4]=DIA[4];
    assign  DIADI[5]=DIA[5];
    assign  DIADI[6]=DIA[6];
    assign  DIADI[7]=DIA[7];

    assign  DIADI[8]=1'b0;
    assign  DIADI[9]=1'b0;
    assign  DIADI[10]=1'b0;
    assign  DIADI[11]=1'b0;
    assign  DIADI[12]=1'b0;
    assign  DIADI[13]=1'b0;
    assign  DIADI[14]=1'b0;
    assign  DIADI[15]=1'b0;

    assign  DIBDI[0]=DIB[0];
    assign  DIBDI[1]=DIB[1];
    assign  DIBDI[2]=DIB[2];
    assign  DIBDI[3]=DIB[3];
    assign  DIBDI[4]=DIB[4];
    assign  DIBDI[5]=DIB[5];
    assign  DIBDI[6]=DIB[6];
    assign  DIBDI[7]=DIB[7];

    assign  DIBDI[8]=1'b0;
    assign  DIBDI[9]=1'b0;
    assign  DIBDI[10]=1'b0;
    assign  DIBDI[11]=1'b0;
    assign  DIBDI[12]=1'b0;
    assign  DIBDI[13]=1'b0;
    assign  DIBDI[14]=1'b0;
    assign  DIBDI[15]=1'b0;

    assign  ADDRARDADDR[0]=1'b0;
    assign  ADDRARDADDR[1]=1'b0;
    assign  ADDRARDADDR[2]=1'b0;
    assign  ADDRARDADDR[3]=ADA[0];
    assign  ADDRARDADDR[4]=ADA[1];
    assign  ADDRARDADDR[5]=ADA[2];
    assign  ADDRARDADDR[6]=ADA[3];
    assign  ADDRARDADDR[7]=ADA[4];
    assign  ADDRARDADDR[8]=ADA[5];
    assign  ADDRARDADDR[9]=ADA[6];
    assign  ADDRARDADDR[10]=ADA[7];
    assign  ADDRARDADDR[11]=ADA[8];
    assign  ADDRARDADDR[12]=ADA[9];
    assign  ADDRARDADDR[13]=ADA[10];

    assign  ADDRBWRADDR[0]=1'b0;
    assign  ADDRBWRADDR[1]=1'b0;
    assign  ADDRBWRADDR[2]=1'b0;
    assign  ADDRBWRADDR[3]=ADB[0];
    assign  ADDRBWRADDR[4]=ADB[1];
    assign  ADDRBWRADDR[5]=ADB[2];
    assign  ADDRBWRADDR[6]=ADB[3];
    assign  ADDRBWRADDR[7]=ADB[4];
    assign  ADDRBWRADDR[8]=ADB[5];
    assign  ADDRBWRADDR[9]=ADB[6];
    assign  ADDRBWRADDR[10]=ADB[7];
    assign  ADDRBWRADDR[11]=ADB[8];
    assign  ADDRBWRADDR[12]=ADB[9];
    assign  ADDRBWRADDR[13]=ADB[10];

    assign  DIPADIP[0]=1'b0;
    assign  DIPADIP[1]=1'b0;
    assign  DIPBDIP[1]=1'b0;
    assign  DIPBDIP[0]=1'b0;
endmodule 
