///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.20)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-bit cascadable Full Adder with Carry-In, Carry-out
// /___/   /\     Filename    : ADD8.v
// \   \  /  \    Timestamp   : Mon May 08 2006
//  \___\/\___\
//
// Revision:
//    05/08/06 - Initial version.
//    CR# 234574 - 07/25/06 - Modified order of pins, SUM pin name, logic.
// End Revision


`timescale  100 ps / 10 ps

module ADD8 (CO, OFL, S, A, B, CI);


   output 	      CO;
   output 	      OFL;
   output [7:0]       S;

   input  [7:0]       A;
   input  [7:0]       B;
   input              CI;

   assign   {CO, S} = A + B + CI;
   assign   OFL     = ( A[7] & B[7] & (~S[7])) | ((~A[7]) & (~B[7]) & S[7]);

endmodule
