///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       2-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB2RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB2RE(CEO, Q0, Q1, TC, C, CE, R);
   
   parameter TERMINAL_COUNT = 2'b11;
   
   output             CEO;
   output             Q0;
   output             Q1;
   output             TC;
   
   input 	      C;	
   input 	      CE;	
   input 	      R;	
   
   reg                Q0;
   reg                Q1;
   
   always @(posedge C)
     begin
	if (R)
	  {Q1, Q0} <= 2'b00;
	else if (CE)
	  {Q1,Q0} <= {Q1,Q0} + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = R ? 1'b0 : ({Q1,Q0} == TERMINAL_COUNT); 
   
endmodule
