///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       Toggle Flip-Flop with Toggle and Clock Enable and Synchronous Reset and Set
// /___/   /\     Filename    : FTRSE.v
// \   \  /  \    Timestamp   : Tue Jul 18 2006
//  \___\/\___\
//
// Revision:
//    07/18/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module FTRSE(Q, C, CE, R, S, T);
   
   output             Q;

   input 	      C;	
   input 	      CE;	
   input 	      R;	
   input              S;
   input              T;
   
   parameter INIT = 1'b0;
   reg                Q = INIT;

   always @(posedge C)
     begin
	if (R)
	  Q <= 1'b0;
        else if(S)
          Q <= 1'b1;
        else if (CE)
	  if(T)
          Q <= !Q;
     end
   
endmodule
