///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       16-Bit Loadable Serial/Parallel-In Parallel-Out Shift Register with Clock Enable and Asynchronous Clear
// /___/   /\     Filename    : SR16CLE.v
// \   \  /  \    Timestamp   : Fri Jul 21 2006
//  \___\/\___\
//
// Revision:
//    07/21/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module SR10CLE(Q, C, CE, CLR, D, L, SLI) ;
  
   
   output [9:0]      Q;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   input  [9:0]      D;
   input              L;
   input              SLI;
   
   reg    [9:0]      Q;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  Q <= 10'b00_0000_0000;
        else if (L)
           Q <= D;
	else if (CE)
          Q <= {Q[8:0], SLI};
     end
   
   
endmodule
