module TOP_SDGS7(TXD_IN,BTN1,BTN2,CLKIN1,RXD_OUT,LED1,LED2,LED3,LED4);

	//Port List 
	input     TXD_IN;
	input     BTN1;
	input     BTN2;
	input     CLKIN1;
	output    RXD_OUT;
	output    LED1;
	output    LED2;
	output    LED3;
	output    LED4;

	//Net List 
	wire      I92_ACQMD_ON;
	wire      I92_ACQ_RUN;
	wire      I11_CLKFBOUT;
	wire      I11_CLKOUT2;
	wire      I11_CLKOUT5;
	wire      CLK_COM;
	wire      I92_TXO;
	wire      I89_O;
	wire      [7:0] I123_S;
	wire      [7:0] I133_Q;
	wire      I119_O;
	wire      I115_Q0;
	wire      I121_O;
	wire      I112_TC;
	wire      I147_O;
	wire      I148_O;
	wire      I112_CEO;
	wire      CLK_SYS;
	wire      [7:0] I92_RXDO;
	wire      [7:0] I116_V;
	wire      [15:0] I118_Q;
	wire      VCC;
	wire      I92_RXOK;
	wire      GND;
	wire      I115_CEO;
	wire      [7:0] I112_Q;
	wire      I122_Q;
	wire      [7:0] I92_LOBYTE;
	wire      [7:0] I92_HIBYTE;
	wire      I138_BTN2;
	wire      I137_BTN1;

	//Lower module connection 
	OBUF Z1C0008(.O(LED3),.I(I92_ACQMD_ON));
	OBUF Z1C0009(.O(LED4),.I(I92_ACQ_RUN));
	MMCME2_BASE_12M_50X Z1C0011(.CLKIN1(CLKIN1),.CLKFBIN(I11_CLKFBOUT),.CLKOUT2(I11_CLKOUT2),.CLKOUT5(I11_CLKOUT5),.CLKFBOUT(I11_CLKFBOUT));
	BUFG Z1C0014(.I(I11_CLKOUT5),.O(CLK_COM));
	OBUF Z1C0086(.O(RXD_OUT),.I(I92_TXO));
	IBUF Z1C0089(.I(TXD_IN),.O(I89_O));
	BV_SDEBUG Z1C0092(.RXI(I89_O),.VAL_A(I123_S[7:0]),.VAL_B(I133_Q[7:0]),.D0(I119_O),.D1(I115_Q0),.D2(I121_O),.D3(I112_TC),.D4(I147_O),.D5(I148_O),.D6(I112_Q[6]),.D7(I112_Q[7]),.EXTRG1(I112_CEO),.EXTRG2(I89_O),.CLK(CLK_SYS),.TXO(I92_TXO),.LOBYTE(I92_LOBYTE[7:0]),.HIBYTE(I92_HIBYTE[7:0]),.RXDO(I92_RXDO[7:0]),.ACQ_RUN(I92_ACQ_RUN),.ACQMD_ON(I92_ACQMD_ON),.B_RATE(I116_V[7:0]),.DTEX(I118_Q[15:0]),.ADEX(I118_Q[10:0]),.WEEX(VCC),.CLKEX(CLK_SYS),.TXDI(I92_RXDO[7:0]),.RXOK(I92_RXOK),.TXST(I92_RXOK),.CLK_COM(CLK_COM));
	CB8CE Z1C0112(.CEO(I112_CEO),.CLR(GND),.C(CLK_SYS),.CE(I115_CEO),.Q(I112_Q[7:0]),.TC(I112_TC));
	CB2CE Z1C0115(.Q0(I115_Q0),.CEO(I115_CEO),.CE(VCC),.C(CLK_SYS),.CLR(GND));
	CONST3 Z1C0116(.V(I116_V[7:4]));
	CONST1 Z1C0117(.V(I116_V[3:0]));
	CB16CE Z1C0118(.CLR(GND),.C(CLK_SYS),.CE(VCC),.Q(I118_Q[15:0]));
	XOR2 Z1C0119(.I0(I115_Q0),.I1(I122_Q),.O(I119_O));
	INV Z1C0121(.I(I112_CEO),.O(I121_O));
	FD_1 Z1C0122(.C(CLK_SYS),.D(I115_Q0),.Q(I122_Q));
	defparam Z1C0122.INIT=1'b0;
	ADD8 Z1C0123(.A(I92_LOBYTE[7:0]),.B(I92_HIBYTE[7:0]),.S(I123_S[7:0]),.CI(GND));
	VCC Z1C0124(.P(VCC));
	GND Z1C0126(.G(GND));
	OBUF Z1C0129(.O(LED1),.I(I92_LOBYTE[0]));
	OBUF Z1C0130(.O(LED2),.I(I92_HIBYTE[0]));
	FD8CE Z1C0133(.Q(I133_Q[7:0]),.D(I118_Q[15:8]),.CLR(I138_BTN2),.CE(I137_BTN1),.C(CLK_SYS));
	IBUF Z1C0137(.I(BTN1),.O(I137_BTN1));
	IBUF Z1C0138(.I(BTN2),.O(I138_BTN2));
	BUFG Z1C0144(.I(I11_CLKOUT2),.O(CLK_SYS));
	BV_SYNCPLS Z1C0147(.I(I112_CEO),.CLKIN(CLK_SYS),.CLKOUT(CLK_COM),.O(I147_O));
	BV_SYNCPLS Z1C0148(.I(I147_O),.CLKIN(CLK_COM),.CLKOUT(CLK_SYS),.O(I148_O));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.20)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-bit cascadable Full Adder with Carry-In, Carry-out
// /___/   /\     Filename    : ADD8.v
// \   \  /  \    Timestamp   : Mon May 08 2006
//  \___\/\___\
//
// Revision:
//    05/08/06 - Initial version.
//    CR# 234574 - 07/25/06 - Modified order of pins, SUM pin name, logic.
// End Revision


`timescale  100 ps / 10 ps

module ADD8 (CO, OFL, S, A, B, CI);


   output 	      CO;
   output 	      OFL;
   output [7:0]       S;

   input  [7:0]       A;
   input  [7:0]       B;
   input              CI;

   assign   {CO, S} = A + B + CI;
   assign   OFL     = ( A[7] & B[7] & (~S[7])) | ((~A[7]) & (~B[7]) & S[7]);

endmodule
///////////////////////////////////////////////////////////////////////////////

`timescale  100 ps / 10 ps

module BUF (O, I);
    

   output  O;

   input  I;


assign O = I;

endmodule
///////////////////////////////////////////////////////////////////////////////

`timescale  100 ps / 10 ps

module BUF4 (O, I);
    

   output [3:0] O;

   input  [3:0] I;


assign O = I;

endmodule
///////////////////////////////////////////////////////////////////////////////

`timescale  100 ps / 10 ps

module BUF8 (O, I);
    

   output [7:0] O;

   input  [7:0] I;


assign O = I;

endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       2-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB2RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB2RE(CEO, Q0, Q1, TC, C, CE, R);
   
   parameter TERMINAL_COUNT = 2'b11;
   
   output             CEO;
   output             Q0;
   output             Q1;
   output             TC;
   
   input 	      C;	
   input 	      CE;	
   input 	      R;	
   
   reg                Q0;
   reg                Q1;
   
   always @(posedge C)
     begin
	if (R)
	  {Q1, Q0} <= 2'b00;
	else if (CE)
	  {Q1,Q0} <= {Q1,Q0} + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = R ? 1'b0 : ({Q1,Q0} == TERMINAL_COUNT); 
   
endmodule


`timescale 100 ps / 10 ps

module FD4CE_BUS(Q, C, CE, CLR, D);

   
   output [3:0]       Q;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   input  [3:0]       D;
   
   reg    [3:0]       Q;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  Q <= 4'b0000;
	else if (CE)
          Q <= D;
     end
   
   
endmodule
module ONESHOT_D1(I,CK,Q);

	//Port List 
	input     I;
	input     CK;
	output    Q;

	//Net List 
	wire      I1_Q;
	wire      I8_Q;

	//Lower module connection 
	FD Z1C0001(.Q(I1_Q),.D(I),.C(CK));
	defparam Z1C0001.INIT=1'b0;
	AND2B1 Z1C0005(.O(Q),.I1(I1_Q),.I0(I8_Q));
	FD Z1C0008(.Q(I8_Q),.D(I1_Q),.C(CK));
	defparam Z1C0008.INIT=1'b0;
endmodule 
module BV_SD_CMDEC(RXD,RX_OK,TIMEOUT,CLK,CMD_YES,CMD_CEO,CMDO,PRM1_CEO,PRM2_CEO);

	//Port List 
	input     [7:0] RXD;
	input     RX_OK;
	input     TIMEOUT;
	input     CLK;
	output    CMD_YES;
	output    CMD_CEO;
	output    [3:0] CMDO;
	output    PRM1_CEO;
	output    PRM2_CEO;

	//Net List 
	wire      I1_Q1;
	wire      I1_Q0;
	wire      I1_TC;
	wire      I4_O;
	wire      I47_Q;
	wire      FIRST_BYTE;
	wire      CMD_EN;
	wire      [7:0] I17_O;
	wire      AD_Ax;
	wire      CMD1_CE;
	wire      VCC;
	wire      GND;
	wire      I50_Q;
	wire      I53_NOT_CMD;

	//Lower module connection 
	CB2RE Z1C0001(.Q1(I1_Q1),.Q0(I1_Q0),.TC(I1_TC),.CE(I4_O),.C(CLK),.R(TIMEOUT));
	AND2B1 Z1C0004(.O(I4_O),.I1(I47_Q),.I0(I1_TC));
	AND3B2 Z1C0012(.I0(I1_Q1),.I1(I1_Q0),.I2(I4_O),.O(FIRST_BYTE));
	AND4B1 Z1C0013(.I0(I1_Q1),.I1(I1_Q0),.I2(I4_O),.I3(CMD_EN),.O(PRM1_CEO));
	BUF8 Z1C0017(.I(RXD[7:0]),.O(I17_O[7:0]));
	AND4B2 Z1C0018(.I0(I17_O[4]),.I1(I17_O[6]),.I2(I17_O[5]),.I3(I17_O[7]),.O(AD_Ax));
	AND2 Z1C0023(.I0(FIRST_BYTE),.I1(AD_Ax),.O(CMD1_CE));
	FDRE Z1C0025(.C(CLK),.CE(CMD1_CE),.D(VCC),.Q(CMD_EN),.R(TIMEOUT));
	defparam Z1C0025.INIT=1'b0;
	VCC Z1C0028(.P(VCC));
	FD4CE_BUS Z1C0030(.Q(CMDO[3:0]),.D(I17_O[3:0]),.CLR(GND),.CE(I50_Q),.C(CLK));
	GND Z1C0035(.G(GND));
	AND4B1 Z1C0039(.I0(I1_Q0),.I1(I1_Q1),.I2(I4_O),.I3(CMD_EN),.O(PRM2_CEO));
	ONESHOT_D1 Z1C0044(.I(CMD_EN),.CK(CLK),.Q(CMD_CEO));
	ONESHOT_D1 Z1C0047(.I(RX_OK),.CK(CLK),.Q(I47_Q));
	FD Z1C0050(.Q(I50_Q),.D(CMD1_CE),.C(CLK));
	defparam Z1C0050.INIT=1'b0;
	FDRE Z1C0052(.C(CLK),.CE(CMD1_CE),.D(VCC),.Q(CMD_YES),.R(I53_NOT_CMD));
	defparam Z1C0052.INIT=1'b0;
	AND2B1 Z1C0053(.O(I53_NOT_CMD),.I1(FIRST_BYTE),.I0(AD_Ax));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       8-Bit Data Register with Clock Enable and Asynchronous Clear
// /___/   /\     Filename    : FD8CE.v
// \   \  /  \    Timestamp   : Tue Jul 18 2006
//  \___\/\___\
//
// Revision:
//    07/18/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module FD8CE(Q, C, CE, CLR, D);

   
   output [7:0]       Q;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   input  [7:0]       D;
   
   reg    [7:0]       Q;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  Q <= 8'b0000_0000;
	else if (CE)
          Q <= D;
     end
   
   
endmodule
module BV_SD_PINOUT(RXDI,CMND,PRM2,PRM1,CLK,LOBYTE,HIBYTE);

	//Port List 
	input     [7:0] RXDI;
	input     CMND;
	input     PRM2;
	input     PRM1;
	input     CLK;
	output    [7:0] LOBYTE;
	output    [7:0] HIBYTE;

	//Net List 
	wire      GND;
	wire      I31_O;
	wire      I32_O;

	//Lower module connection 
	GND Z1C0018(.G(GND));
	FD8CE Z1C0025(.Q(LOBYTE[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I31_O),.C(CLK));
	FD8CE Z1C0026(.Q(HIBYTE[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I32_O),.C(CLK));
	AND2 Z1C0031(.I0(PRM1),.I1(CMND),.O(I31_O));
	AND2 Z1C0032(.I0(PRM2),.I1(CMND),.O(I32_O));
endmodule 
///////////////////////////////////////////////////////////////////////////////

`timescale  100 ps / 10 ps

module BUF11 (O, I);
    

   output [10:0] O;

   input  [10:0] I;


assign O = I;

endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       3- to 8-Line Decoder/Demultiplexer with Enable
// /___/   /\     Filename    : D3_8E.v
// \   \  /  \    Timestamp   : Fri July 14 2006
//  \___\/\___\
//
// Revision:
//    07/14/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module D3_8E (D0, D1, D2, D3, D4, D5, D6, D7, A0, A1, A2, E);
    

   output D0;
   output D1;
   output D2;
   output D3;
   output D4;
   output D5;
   output D6;
   output D7;

   input  A0;
   input  A1;
   input  A2;
   input  E;
  
   reg D0;
   reg D1;
   reg D2;
   reg D3;
   reg D4;
   reg D5;
   reg D6;
   reg D7;

      always @ (A0 or A1 or A2 or E)
      begin
         if(!E)
           {D7, D6, D5, D4, D3, D2, D1, D0} <= 8'b0000_0000;
        else
        begin
           case({A2,A1,A0})
             3'b000 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b0000_0001;
             3'b001 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b0000_0010;
             3'b010 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b0000_0100;
             3'b011 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b0000_1000;
             3'b100 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b0001_0000;
             3'b101 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b0010_0000;
             3'b110 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b0100_0000;
             3'b111 :  {D7, D6, D5, D4, D3, D2, D1, D0} <=  8'b1000_0000;
          endcase
        end
     end 

endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       4-Bit Data Register with Clock Enable and Asynchronous Clear
// /___/   /\     Filename    : FD4CE.v
// \   \  /  \    Timestamp   : Tue Jul 18 2006
//  \___\/\___\
//
// Revision:
//    07/18/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module FD4CE(Q0, Q1, Q2, Q3, C, CE, CLR, D0, D1, D2, D3);
   
   output             Q0;
   output             Q1;
   output             Q2;
   output             Q3;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   input              D0;
   input              D1;
   input              D2;
   input              D3;
   
   reg                Q0;
   reg                Q1;
   reg                Q2;
   reg                Q3;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  {Q3, Q2, Q1, Q0} <= 4'b0000;
	else if (CE)
          {Q3, Q2, Q1, Q0} <= {D3, D2, D1, D0};
     end
   
   
endmodule
module BV_ADDEC8(A0,A1,A2,E1,E2,CLK,Q0,Q1,Q2,Q3,Q4,Q5,Q6,Q7);

	//Port List 
	input     A0;
	input     A1;
	input     A2;
	input     E1;
	input     E2;
	input     CLK;
	output    Q0;
	output    Q1;
	output    Q2;
	output    Q3;
	output    Q4;
	output    Q5;
	output    Q6;
	output    Q7;

	//Net List 
	wire      I3_O;
	wire      I1_D7;
	wire      I1_D6;
	wire      I1_D5;
	wire      I1_D4;
	wire      I1_D3;
	wire      I1_D2;
	wire      I1_D1;
	wire      I1_D0;
	wire      GND;
	wire      VCC;

	//Lower module connection 
	D3_8E Z1C0001(.E(I3_O),.D7(I1_D7),.D6(I1_D6),.D5(I1_D5),.D4(I1_D4),.D3(I1_D3),.D2(I1_D2),.D1(I1_D1),.D0(I1_D0),.A2(A2),.A1(A1),.A0(A0));
	AND2 Z1C0003(.I0(E2),.I1(E1),.O(I3_O));
	FD4CE Z1C0010(.C(CLK),.CLR(GND),.CE(VCC),.Q2(Q2),.Q3(Q3),.D3(I1_D3),.D2(I1_D2),.D0(I1_D0),.D1(I1_D1),.Q1(Q1),.Q0(Q0));
	FD4CE Z1C0011(.C(CLK),.CLR(GND),.CE(VCC),.Q2(Q6),.Q3(Q7),.D3(I1_D7),.D2(I1_D6),.D0(I1_D4),.D1(I1_D5),.Q1(Q5),.Q0(Q4));
	GND Z1C0021(.G(GND));
	VCC Z1C0022(.P(VCC));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       2-to-1 Multiplexer
// /___/   /\     Filename    : M2_1.v
// \   \  /  \    Timestamp   : Tue Jul 11 2006
//  \___\/\___\
//
// Revision:
//    07/11/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module M2_1 (O, D0, D1, S0);
    

   output O;

   input  D0;
   input  D1;
   input  S0;

   reg O;

   always @ ( D0 or D1 or S0)
   begin
      case(S0)
      1'b0 : O <= D0;
      1'b1 : O <= D1;
      endcase
   end
    
endmodule
module BV_SD_ANTI1(I,IDLY,CE,EN,SPL2X,CLK,O);

	//Port List 
	input     I;
	input     IDLY;
	input     CE;
	input     EN;
	input     SPL2X;
	input     CLK;
	output    O;

	//Net List 
	wire      I1_EDGEDET;
	wire      VCC;
	wire      I2_Q;
	wire      I26_O;
	wire      I20_O;
	wire      I4_O;
	wire      I63_EDGE2X;
	wire      GND;
	wire      TGLE;
	wire      I45_EDG2X;
	wire      I79_THROGH;
	wire      I78_DET;
	wire      I85_O;
	wire      I80_DLY2;

	//Lower module connection 
	XOR2 Z1C0001(.I0(IDLY),.I1(I),.O(I1_EDGEDET));
	FDRE Z1C0002(.C(CLK),.CE(I1_EDGEDET),.D(VCC),.Q(I2_Q),.R(I26_O));
	defparam Z1C0002.INIT=1'b0;
	M2_1 Z1C0004(.D0(IDLY),.D1(I20_O),.O(I4_O),.S0(I63_EDGE2X));
	VCC Z1C0015(.P(VCC));
	FDCE Z1C0019(.C(CLK),.CE(CE),.CLR(GND),.D(I4_O),.Q(TGLE));
	defparam Z1C0019.INIT=1'b0;
	INV Z1C0020(.I(TGLE),.O(I20_O));
	GND Z1C0023(.G(GND));
	AND2B1 Z1C0026(.O(I26_O),.I1(CE),.I0(I1_EDGEDET));
	FDRE Z1C0045(.C(CLK),.CE(I1_EDGEDET),.D(I2_Q),.Q(I45_EDG2X),.R(CE));
	defparam Z1C0045.INIT=1'b0;
	AND2 Z1C0063(.I0(EN),.I1(I45_EDG2X),.O(I63_EDGE2X));
	M2_1 Z1C0076(.D0(I79_THROGH),.D1(TGLE),.O(O),.S0(I78_DET));
	FDCE Z1C0078(.C(CLK),.CE(CE),.CLR(GND),.D(I63_EDGE2X),.Q(I78_DET));
	defparam Z1C0078.INIT=1'b0;
	FDCE Z1C0079(.C(CLK),.CE(CE),.CLR(GND),.D(I85_O),.Q(I79_THROGH));
	defparam Z1C0079.INIT=1'b0;
	FDCE Z1C0080(.C(CLK),.CE(CE),.CLR(GND),.D(IDLY),.Q(I80_DLY2));
	defparam Z1C0080.INIT=1'b0;
	M2_1 Z1C0085(.D0(I80_DLY2),.D1(IDLY),.O(I85_O),.S0(SPL2X));
endmodule 
module BV_SD_ANIT8(IN,DLY,CE,SPL2X,EN,CLK,O);

	//Port List 
	input     [7:0] IN;
	input     [7:0] DLY;
	input     CE;
	input     SPL2X;
	input     EN;
	input     CLK;
	output    [7:0] O;

	//Net List 
	wire      [7:0] I15_O;
	wire      [7:0] I19_O;
	wire      [7:0] XI16_I;

	//Lower module connection 
	BV_SD_ANTI1 Z1C0001(.I(I15_O[0]),.IDLY(I19_O[0]),.CE(CE),.CLK(CLK),.O(XI16_I[0]),.EN(EN),.SPL2X(SPL2X));
	BV_SD_ANTI1 Z1C0002(.I(I15_O[1]),.IDLY(I19_O[1]),.CE(CE),.CLK(CLK),.O(XI16_I[1]),.EN(EN),.SPL2X(SPL2X));
	BV_SD_ANTI1 Z1C0003(.I(I15_O[2]),.IDLY(I19_O[2]),.CE(CE),.CLK(CLK),.O(XI16_I[2]),.EN(EN),.SPL2X(SPL2X));
	BV_SD_ANTI1 Z1C0004(.I(I15_O[3]),.IDLY(I19_O[3]),.CE(CE),.CLK(CLK),.O(XI16_I[3]),.EN(EN),.SPL2X(SPL2X));
	BV_SD_ANTI1 Z1C0005(.I(I15_O[4]),.IDLY(I19_O[4]),.CE(CE),.CLK(CLK),.O(XI16_I[4]),.EN(EN),.SPL2X(SPL2X));
	BV_SD_ANTI1 Z1C0006(.I(I15_O[5]),.IDLY(I19_O[5]),.CE(CE),.CLK(CLK),.O(XI16_I[5]),.EN(EN),.SPL2X(SPL2X));
	BV_SD_ANTI1 Z1C0007(.I(I15_O[6]),.IDLY(I19_O[6]),.CE(CE),.CLK(CLK),.O(XI16_I[6]),.EN(EN),.SPL2X(SPL2X));
	BV_SD_ANTI1 Z1C0008(.I(I15_O[7]),.IDLY(I19_O[7]),.CE(CE),.CLK(CLK),.O(XI16_I[7]),.EN(EN),.SPL2X(SPL2X));
	BUF8 Z1C0015(.I(IN[7:0]),.O(I15_O[7:0]));
	BUF8 Z1C0016(.I(XI16_I[7:0]),.O(O[7:0]));
	BUF8 Z1C0019(.I(DLY[7:0]),.O(I19_O[7:0]));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-Input AND gate with Non-inverted inputs
// /___/   /\     Filename    : AND8.v
// \   \  /  \    Timestamp   : Thu Jul 13 2006
//  \___\/\___\
//
// Revision:
//    07/13/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module AND8 (O, I0, I1, I2, I3, I4, I5, I6, I7);
    

   output O;

   input I0;
   input I1;
   input I2;
   input I3;
   input I4;
   input I5;
   input I6;
   input I7;

assign O = I0 && I1 && I2 && I3 && I4 && I5 && I6 && I7;

endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB8RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB11RE(CEO, Q, TC, C, CE, R);
   
   parameter TERMINAL_COUNT = 11'b111_1111_1111;
   
   output             CEO;
   output [10:0]       Q;
   output             TC;
   
   input 	      C;	
   input 	      CE;	
   input 	      R;	
   
   reg   [10:0]        Q;
   
   always @(posedge C)
     begin
	if (R)
	  Q <= 11'b000_0000_0000;
	else if (CE)
	  Q <= Q + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = R ? 1'b0 : (Q == TERMINAL_COUNT); 
   
endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB8RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB12RE(CEO, Q, TC, C, CE, R);
   
   parameter TERMINAL_COUNT = 12'b1111_1111_1111;
   
   output             CEO;
   output [11:0]       Q;
   output             TC;
   
   input 	      C;	
   input 	      CE;	
   input 	      R;	
   
   reg   [11:0]        Q;
   
   always @(posedge C)
     begin
	if (R)
	  Q <= 12'b0000_0000_0000;
	else if (CE)
	  Q <= Q + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = R ? 1'b0 : (Q == TERMINAL_COUNT); 
   
endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       Toggle Flip-Flop with Toggle and Clock Enable and Synchronous Reset and Set
// /___/   /\     Filename    : FTRSE.v
// \   \  /  \    Timestamp   : Tue Jul 18 2006
//  \___\/\___\
//
// Revision:
//    07/18/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module FTRSE(Q, C, CE, R, S, T);
   
   output             Q;

   input 	      C;	
   input 	      CE;	
   input 	      R;	
   input              S;
   input              T;
   
   parameter INIT = 1'b0;
   reg                Q = INIT;

   always @(posedge C)
     begin
	if (R)
	  Q <= 1'b0;
        else if(S)
          Q <= 1'b1;
        else if (CE)
	  if(T)
          Q <= !Q;
     end
   
endmodule
module CB1RE(CE,CK,R,Q0,CEO);

	//Port List 
	input     CE;
	input     CK;
	input     R;
	output    Q0;
	output    CEO;

	//Net List 
	wire      I6_G;
	wire      I8_P;

	//Lower module connection 
	FTRSE Z1C0002(.Q(Q0),.S(I6_G),.T(I8_P),.R(R),.CE(CE),.C(CK));
	GND Z1C0006(.G(I6_G));
	VCC Z1C0008(.P(I8_P));
	AND2 Z1C0014(.I0(CE),.I1(Q0),.O(CEO));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB8RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB8RE(CEO, Q, TC, C, CE, R);
   
   parameter TERMINAL_COUNT = 8'b1111_1111;
   
   output             CEO;
   output [7:0]       Q;
   output             TC;
   
   input 	      C;	
   input 	      CE;	
   input 	      R;	
   
   reg   [7:0]        Q;
   
   always @(posedge C)
     begin
	if (R)
	  Q <= 8'b0000_0000;
	else if (CE)
	  Q <= Q + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = R ? 1'b0 : (Q == TERMINAL_COUNT); 
   
endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-bit Identity Comparator
// /___/   /\     Filename    : COMP8.v
// \   \  /  \    Timestamp   : Fri Jul 07 2006
//  \___\/\___\
//
// Revision:
//    07/07/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module COMP8 (EQ, A, B);
    

   output EQ;

   input  [7:0] A;
   input  [7:0] B;

   assign EQ = (A==B) ;

endmodule
module DLY3(D,CK,Q3,Q2,Q1);

	//Port List 
	input     D;
	input     CK;
	output    Q3;
	output    Q2;
	output    Q1;

	//Net List 

	//Lower module connection 
	FD Z1C0001(.Q(Q1),.D(D),.C(CK));
	defparam Z1C0001.INIT=1'b0;
	FD Z1C0002(.Q(Q2),.D(Q1),.C(CK));
	defparam Z1C0002.INIT=1'b0;
	FD Z1C0003(.Q(Q3),.D(Q2),.C(CK));
	defparam Z1C0003.INIT=1'b0;
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       2-to-1 Multiplexer
// /___/   /\     Filename    : M2_1.v
// \   \  /  \    Timestamp   : Tue Jul 11 2006
//  \___\/\___\
//
// Revision:
//    07/11/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module M2_1_8 (O, A, B, S0);
    
   output [7:0] O;

   input  [7:0] A;
   input  [7:0] B;
   input  S0;

   reg [7:0] O;

   always @*
   begin
      case(S0)
      1'b0 : O <= A;
      1'b1 : O <= B;
      endcase
   end
    
endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-Input OR gate with Non-inverted inputs
// /___/   /\     Filename    : OR8.v
// \   \  /  \    Timestamp   : Wed Jul 19 2006
//  \___\/\___\
//
// Revision:
//    07/19/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module OR8 (O, I0, I1, I2, I3, I4, I5, I6, I7);
    

   output O;

   input I0;
   input I1;
   input I2;
   input I3;
   input I4;
   input I5;
   input I6;
   input I7;

assign O = (I0 || I1 || I2 || I3 || I4 || I5 || I6 || I7);

endmodule
module OR8_BUS(I,O);

	//Port List 
	input     [7:0] I;
	output    O;

	//Net List 

	//Lower module connection 
	OR8 Z1C0006(.I0(I[7]),.I1(I[6]),.I2(I[5]),.I5(I[2]),.I6(I[1]),.I7(I[0]),.O(O),.I4(I[3]),.I3(I[4]));
endmodule 
module BV_SD_SPCNT(READ_CE,R_ADR,TRGIN,ACQ_MODE,ACQMD_R,CMDI,RXDI,PRAM1,PRAM2,CLK,WE1,WE2,ADR,SPLX2_ACQ,SPLCE,SPL12,PHASEO,ACQMD_ON,SEL_BYTE,ACQ_RUN);

	//Port List 
	input     READ_CE;
	input     R_ADR;
	input     TRGIN;
	input     ACQ_MODE;
	input     ACQMD_R;
	input     CMDI;
	input     [7:0] RXDI;
	input     PRAM1;
	input     PRAM2;
	input     CLK;
	output    WE1;
	output    WE2;
	output    [10:0] ADR;
	output    SPLX2_ACQ;
	output    SPLCE;
	output    SPL12;
	output    PHASEO;
	output    ACQMD_ON;
	output    SEL_BYTE;
	output    ACQ_RUN;

	//Net List 
	wire      I39_O;
	wire      I83_CNT_RESET;
	wire      I4_CEO;
	wire      I11_ADRS_CE;
	wire      GND;
	wire      VCC;
	wire      I18_O;
	wire      [7:0] I29_SPLQ;
	wire      SPLCE1;
	wire      I36_O;
	wire      I80_ACQ_ST;
	wire      [7:0] I22_Q;
	wire      SPLX2;
	wire      I42_WRCE;
	wire      I51_CEO;
	wire      I53_O;
	wire      I55_O;
	wire      [7:0] I65_Q;
	wire      [7:0] I131_O;
	wire      I64_EQ_STOP;
	wire      I69_O;
	wire      I88_TRGIN_AFT;
	wire      I66_TRGACK;
	wire      I153_TRGACK2;
	wire      I74_O;
	wire      I94_ACQ_DLY;
	wire      I79_Q;
	wire      I85_TURN_ALL;
	wire      [11:0] I124_Q;
	wire      SPLCEX;
	wire      SPLX1;

	//Lower module connection 
	CB1RE Z1C0004(.CE(I39_O),.CK(CLK),.R(I83_CNT_RESET),.Q0(SEL_BYTE),.CEO(I4_CEO));
	OR2 Z1C0011(.I0(SPLX2_ACQ),.I1(I4_CEO),.O(I11_ADRS_CE));
	GND Z1C0014(.G(GND));
	VCC Z1C0016(.P(VCC));
	AND2 Z1C0018(.I0(PRAM1),.I1(CMDI),.O(I18_O));
	FD8CE Z1C0022(.Q(I22_Q[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I18_O),.C(CLK));
	COMP8 Z1C0026(.B(I22_Q[7:0]),.A(I29_SPLQ[7:0]),.EQ(SPLCE1));
	CB8RE Z1C0029(.Q(I29_SPLQ[7:0]),.C(CLK),.R(I36_O),.CE(VCC));
	OR2 Z1C0036(.I0(I80_ACQ_ST),.I1(SPLCE1),.O(I36_O));
	AND8 Z1C0037(.I0(I22_Q[7]),.I1(I22_Q[6]),.I2(I22_Q[5]),.I3(I22_Q[4]),.I4(I22_Q[3]),.I5(I22_Q[2]),.I6(I22_Q[1]),.I7(I22_Q[0]),.O(SPLX2));
	M2_1 Z1C0039(.D0(READ_CE),.D1(I42_WRCE),.O(I39_O),.S0(ACQMD_ON));
	AND2 Z1C0042(.I0(SPLCE),.I1(ACQ_RUN),.O(I42_WRCE));
	AND2 Z1C0045(.I0(SPLX2),.I1(ACQ_RUN),.O(SPLX2_ACQ));
	CB11RE Z1C0051(.Q(ADR[10:0]),.C(CLK),.R(I83_CNT_RESET),.CE(I11_ADRS_CE),.CEO(I51_CEO));
	AND3 Z1C0053(.I0(SEL_BYTE),.I1(I39_O),.I2(ACQ_RUN),.O(I53_O));
	AND3B1 Z1C0055(.I0(SEL_BYTE),.I1(I39_O),.I2(ACQ_RUN),.O(I55_O));
	OR2 Z1C0056(.I0(SPLX2_ACQ),.I1(I55_O),.O(WE1));
	OR2 Z1C0057(.I0(SPLX2_ACQ),.I1(I53_O),.O(WE2));
	COMP8 Z1C0064(.B(I65_Q[7:0]),.A(I131_O[7:0]),.EQ(I64_EQ_STOP));
	FD8CE Z1C0065(.Q(I65_Q[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I69_O),.C(CLK));
	FDRE Z1C0066(.C(CLK),.CE(I88_TRGIN_AFT),.D(VCC),.Q(I66_TRGACK),.R(I80_ACQ_ST));
	defparam Z1C0066.INIT=1'b0;
	AND2 Z1C0069(.I0(PRAM2),.I1(CMDI),.O(I69_O));
	INV Z1C0074(.I(I153_TRGACK2),.O(I74_O));
	FDRE Z1C0079(.C(CLK),.CE(I94_ACQ_DLY),.D(VCC),.Q(I79_Q),.R(I64_EQ_STOP));
	defparam Z1C0079.INIT=1'b0;
	ONESHOT_D1 Z1C0080(.I(ACQ_MODE),.CK(CLK),.Q(I80_ACQ_ST));
	OR2 Z1C0083(.I0(I80_ACQ_ST),.I1(R_ADR),.O(I83_CNT_RESET));
	FDRE Z1C0085(.C(CLK),.CE(I51_CEO),.D(VCC),.Q(I85_TURN_ALL),.R(I83_CNT_RESET));
	defparam Z1C0085.INIT=1'b0;
	AND3 Z1C0091(.I0(I85_TURN_ALL),.I1(TRGIN),.I2(ACQMD_ON),.O(I88_TRGIN_AFT));
	DLY3 Z1C0094(.D(I80_ACQ_ST),.CK(CLK),.Q3(I94_ACQ_DLY));
	CB12RE Z1C0124(.Q(I124_Q[11:0]),.C(CLK),.R(I74_O),.CE(I42_WRCE));
	OR2 Z1C0128(.I0(SPLX2),.I1(SPLCE1),.O(SPLCEX));
	M2_1_8 Z1C0131(.A(I124_Q[11:4]),.B(I124_Q[10:3]),.O(I131_O[7:0]),.S0(SPLX2));
	OR8_BUS Z1C0147(.I(I22_Q[7:0]),.O(SPLX1));
	OR2B1 Z1C0148(.I0(SPLX1),.I1(SPLX2),.O(SPL12));
	FD Z1C0151(.Q(SPLCE),.D(SPLCEX),.C(CLK));
	defparam Z1C0151.INIT=1'b0;
	FDRE Z1C0153(.C(CLK),.CE(SPLCE),.D(I66_TRGACK),.Q(I153_TRGACK2),.R(I80_ACQ_ST));
	defparam Z1C0153.INIT=1'b0;
	FDRE Z1C0156(.C(CLK),.CE(SPLCE),.D(I79_Q),.Q(ACQ_RUN),.R(GND));
	defparam Z1C0156.INIT=1'b0;
	AND2 Z1C0161(.I0(SPLX2),.I1(ADR[0]),.O(PHASEO));
	FDRE Z1C0175(.C(CLK),.CE(I80_ACQ_ST),.D(VCC),.Q(ACQMD_ON),.R(ACQMD_R));
	defparam Z1C0175.INIT=1'b0;
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       16-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB16RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module
 CB16RE(CEO, Q, TC, C, CE, R);
  
 
   
parameter TERMINAL_COUNT = 16'b1111_1111_1111_1111;
   
  
 
output             CEO;
   
output [15:0]      Q;
   
output             TC;
   
   
input 	      C;	
   
input 	      CE;	
   
input 	      R;	
   
   
reg    [15:0]      Q;
 
  
   
 always @(posedge C)
     

 begin
	
  if (R)
	  Q <= 16'b0000_0000_0000_0000;
	
  else if (CE)
	  Q <= Q + 1;
     
 end
   

   
 assign CEO = TC & CE;
   
 assign TC = R ? 1'b0 : (Q == TERMINAL_COUNT); 
 
  

endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       16-bit Identity Comparator
// /___/   /\     Filename    : COMP16.v
// \   \  /  \    Timestamp   : Fri Jul 07 2006
//  \___\/\___\
//
// Revision:
//    07/07/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module COMP16 (EQ, A, B);
    

   output EQ;

   input  [15:0] A;
   input  [15:0] B;

   assign EQ = (A == B) ;

endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-bit Magnitude Comparator
// /___/   /\     Filename    : COMPM8.v
// \   \  /  \    Timestamp   : Fri Jul 07 2006
//  \___\/\___\
//
// Revision:
//    07/07/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module COMPM8 (GT, LT, A, B);
    

   output GT;
   output LT;

   input  [7:0] A;
   input  [7:0] B;


   assign GT = A > B  ;
   assign LT = A < B  ;

endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       16-to-1 Multiplexer with Enable
// /___/   /\     Filename    : M16_1E.v
// \   \  /  \    Timestamp   : Tue Jul 11 2006
//  \___\/\___\
//
// Revision:
//    07/11/06 - Initial version.
// End Revision

`timescale  100 ps / 10 ps

module M16_1E (O, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, E, S0, S1, S2, S3);
    

   output O;

   input  D0;
   input  D1;
   input  D2;
   input  D3;
   input  D4;
   input  D5;
   input  D6;
   input  D7;
   input  D8;
   input  D9;
   input  D10;
   input  D11;
   input  D12;
   input  D13;
   input  D14;
   input  D15;
   input  E;
   input  S0;
   input  S1;
   input  S2;
   input  S3;

   reg O;

   always @ ( D0 or D1 or D2 or D3 or D4 or D5 or D6 or D7 or D8 or D9 or D10 or D11 or D12 or D13 or D14 or D15 or E or S0 or S1 or S2 or S3)
   begin
      if(!E)
      O <= 1'b0;
      else 
      begin
        case({S3,S2,S1,S0})
        4'b0000 : O <= D0;
        4'b0001 : O <= D1;
        4'b0010 : O <= D2;
        4'b0011 : O <= D3;
        4'b0100 : O <= D4;
        4'b0101 : O <= D5;
        4'b0110 : O <= D6;
        4'b0111 : O <= D7;
        4'b1000 : O <= D8;
        4'b1001 : O <= D9;
        4'b1010 : O <= D10;
        4'b1011 : O <= D11;
        4'b1100 : O <= D12;
        4'b1101 : O <= D13;
        4'b1110 : O <= D14;
        4'b1111 : O <= D15;
        endcase
      end
   end
    
endmodule
module OR16_BUS(I,O);

	//Port List 
	input     [15:0] I;
	output    O;

	//Net List 
	wire      I6_O;
	wire      I7_O;

	//Lower module connection 
	OR8_BUS Z1C0006(.I(I[7:0]),.O(I6_O));
	OR8_BUS Z1C0007(.I(I[15:8]),.O(I7_O));
	OR2 Z1C0009(.I0(I7_O),.I1(I6_O),.O(O));
endmodule 
module BV_SD_TRG(SPL2X,SMPLCE,D,EX1,EX2,RXDI,CMDCE,CMD2,PARAM1,PARAM2,CLK,TRG_MPX,TRGOUT,MODE6,MODE7);

	//Port List 
	input     SPL2X;
	input     SMPLCE;
	input     [7:0] D;
	input     EX1;
	input     EX2;
	input     [7:0] RXDI;
	input     CMDCE;
	input     CMD2;
	input     PARAM1;
	input     PARAM2;
	input     CLK;
	output    TRG_MPX;
	output    TRGOUT;
	output    MODE6;
	output    MODE7;

	//Net List 
	wire      GND;
	wire      I8_PRM1;
	wire      [7:0] I2_Q;
	wire      I7_PRM2;
	wire      VCC;
	wire      I18_TRGMPX;
	wire      AND_EX;
	wire      XOR_EX;
	wire      I26_EQ;
	wire      I25_GT;
	wire      I128_ANYTIME;
	wire      [7:0] I19_O;
	wire      I25_LT;
	wire      I107_O;
	wire      I33_O;
	wire      TRG_PLS;
	wire      [15:0] I76_Q;
	wire      I91_O;
	wire      I89_TRGACKN;
	wire      I79_PRM_F1;
	wire      [15:0] XI86_B;
	wire      I80_PRM_F2;
	wire      I86_NCLKDLY;
	wire      I95_NOTZERO;
	wire      I98_O;
	wire      I100_TRGPLS1;
	wire      [7:0] I1_Q;

	//Lower module connection 
	FD8CE Z1C0001(.Q(I1_Q[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I8_PRM1),.C(CLK));
	FD8CE Z1C0002(.Q(I2_Q[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I7_PRM2),.C(CLK));
	GND Z1C0003(.G(GND));
	VCC Z1C0004(.P(VCC));
	AND2 Z1C0007(.I0(CMDCE),.I1(PARAM2),.O(I7_PRM2));
	AND2 Z1C0008(.I0(CMDCE),.I1(PARAM1),.O(I8_PRM1));
	M16_1E Z1C0018(.O(I18_TRGMPX),.E(VCC),.D8(EX1),.D7(I19_O[7]),.D9(EX2),.D6(I19_O[6]),.D10(AND_EX),.D5(I19_O[5]),.D11(XOR_EX),.D4(I19_O[4]),.D12(I26_EQ),.D3(I19_O[3]),.D13(I25_GT),.D2(I19_O[2]),.D14(PARAM2),.D1(I19_O[1]),.D15(I128_ANYTIME),.D0(I19_O[0]),.S1(I1_Q[1]),.S2(I1_Q[2]),.S3(I1_Q[3]),.S0(I1_Q[0]));
	BUF8 Z1C0019(.I(D[7:0]),.O(I19_O[7:0]));
	COMPM8 Z1C0025(.GT(I25_GT),.LT(I25_LT),.A(I19_O[7:0]),.B(I2_Q[7:0]));
	AND2B2 Z1C0026(.I0(I25_LT),.I1(I25_GT),.O(I26_EQ));
	XOR2 Z1C0033(.I0(I1_Q[5]),.I1(I107_O),.O(I33_O));
	ONESHOT_D1 Z1C0035(.I(I33_O),.CK(CLK),.Q(TRG_PLS));
	AND2 Z1C0039(.I0(EX2),.I1(EX1),.O(AND_EX));
	XOR2 Z1C0043(.I0(EX2),.I1(EX1),.O(XOR_EX));
	BUF Z1C0068(.I(I1_Q[6]),.O(MODE6));
	BUF Z1C0072(.I(I1_Q[7]),.O(MODE7));
	CB16RE Z1C0076(.Q(I76_Q[15:0]),.C(CLK),.R(I91_O),.CE(I89_TRGACKN));
	FD8CE Z1C0077(.Q(XI86_B[7:0]),.D(RXDI[7:0]),.CLR(GND),.CE(I79_PRM_F1),.C(CLK));
	FD8CE Z1C0078(.Q(XI86_B[15:8]),.D(RXDI[7:0]),.CLR(GND),.CE(I80_PRM_F2),.C(CLK));
	AND2 Z1C0079(.I0(CMD2),.I1(PARAM1),.O(I79_PRM_F1));
	AND2 Z1C0080(.I0(CMD2),.I1(PARAM2),.O(I80_PRM_F2));
	COMP16 Z1C0086(.EQ(I86_NCLKDLY),.A(I76_Q[15:0]),.B(XI86_B[15:0]));
	FDRE Z1C0089(.C(CLK),.CE(TRG_PLS),.D(VCC),.Q(I89_TRGACKN),.R(I86_NCLKDLY));
	defparam Z1C0089.INIT=1'b0;
	INV Z1C0091(.I(I89_TRGACKN),.O(I91_O));
	OR16_BUS Z1C0095(.I(XI86_B[15:0]),.O(I95_NOTZERO));
	FD Z1C0097(.Q(TRGOUT),.D(I98_O),.C(CLK));
	defparam Z1C0097.INIT=1'b0;
	M2_1 Z1C0098(.D0(I100_TRGPLS1),.D1(I86_NCLKDLY),.O(I98_O),.S0(I95_NOTZERO));
	FD Z1C0106(.Q(I100_TRGPLS1),.D(TRG_PLS),.C(CLK));
	defparam Z1C0106.INIT=1'b0;
	BV_SD_ANTI1 Z1C0107(.I(I18_TRGMPX),.IDLY(TRG_MPX),.CE(SMPLCE),.EN(I1_Q[6]),.SPL2X(SPL2X),.CLK(CLK),.O(I107_O));
	FD Z1C0109(.Q(TRG_MPX),.D(I18_TRGMPX),.C(CLK));
	defparam Z1C0109.INIT=1'b0;
	INV Z1C0128(.I(I107_O),.O(I128_ANYTIME));
endmodule 
module GN2(G);

	//Port List 
	output    [1:0] G;

	//Net List 

	//Lower module connection 
	GND Z1C0003(.G(G[1]));
	GND Z1C0004(.G(G[0]));
endmodule 
module GN5(G);

	//Port List 
	output    [4:0] G;

	//Net List 

	//Lower module connection 
	GND Z1C0003(.G(G[1]));
	GND Z1C0004(.G(G[0]));
	GND Z1C0011(.G(G[2]));
	GND Z1C0012(.G(G[3]));
	GND Z1C0013(.G(G[4]));
endmodule 
module RAMB16_D8(WEA,DIA,ADA,ENA,CKA,RSTA,CEA,WEB,DIB,ADB,ENB,CKB,RSTB,CEB,DOA,DOB);

	//Port List 
	input     WEA;
	input     [7:0] DIA;
	input     [10:0] ADA;
	input     ENA;
	input     CKA;
	input     RSTA;
	input     CEA;
	input     WEB;
	input     [7:0] DIB;
	input     [10:0] ADB;
	input     ENB;
	input     CKB;
	input     RSTB;
	input     CEB;
	output    [7:0] DOA;
	output    [7:0] DOB;

    wire  [15:0]  DOADO;
    wire  [1:0]   DOPADOP;
    wire  [15:0]  DOBDO;
    wire  [1:0]   DOPBDOP;
    wire  [13:0]  ADDRARDADDR;
   // wire    CLKARDCLK;
   // wire    ENARDEN;
   // wire    REGCEAREGCE;
   // wire    RSTRAMARSTRAM;
   // wire   RSTREGARSTREG;
    wire  [1:0]   WEAX;
    wire  [15:0]  DIADI;
    wire  [1:0]   DIPADIP;
    wire  [13:0]  ADDRBWRADDR;
 //   wire    CLKBWRCLK;
 //   wire    ENBWREN;
//    wire    REGCEB;
 //   wire    RSTRAMB;
 //   wire    RSTREGB;
    wire  [3:0]   WEBX;
    wire  [15:0]  DIBDI;
    wire  [1:0]   DIPBDIP;


RAMB18E1 #(
   // Address Collision Mode: "PERFORMANCE" or "DELAYED_WRITE"
   .RDADDR_COLLISION_HWCONFIG("DELAYED_WRITE"),
   // Collision check: Values ("ALL", "WARNING_ONLY", "GENERATE_X_ONLY" or "NONE")
   .SIM_COLLISION_CHECK("ALL"),
   // DOA_REG, DOB_REG: Optional output register (0 or 1)
   .DOA_REG(0),
   .DOB_REG(0),
   // INITP_00 to INITP_07: Initial contents of parity memory array
   .INITP_00(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_01(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_02(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_03(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_04(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_05(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_06(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_07(256'h0000000000000000000000000000000000000000000000000000000000000000),
   // INIT_00 to INIT_3F: Initial contents of data memory array
   .INIT_00(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_01(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_02(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_03(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_04(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_05(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_06(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_07(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_08(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_09(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_0F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_10(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_11(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_12(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_13(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_14(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_15(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_16(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_17(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_18(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_19(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_1F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_20(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_21(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_22(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_23(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_24(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_25(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_26(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_27(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_28(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_29(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_2F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_30(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_31(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_32(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_33(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_34(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_35(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_36(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_37(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_38(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_39(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3A(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3B(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3C(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3D(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3E(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INIT_3F(256'h0000000000000000000000000000000000000000000000000000000000000000),
   // INIT_A, INIT_B: Initial values on output ports
   .INIT_A(18'h00000),
   .INIT_B(18'h00000),
   // Initialization File: RAM initialization file
   .INIT_FILE("NONE"),
   // RAM Mode: "SDP" or "TDP"
   .RAM_MODE("TDP"),
   // READ_WIDTH_A/B, WRITE_WIDTH_A/B: Read/write width per port
   .READ_WIDTH_A(9),                                                                 // 0-72
   .READ_WIDTH_B(9),                                                                 // 0-18
   .WRITE_WIDTH_A(9),                                                                // 0-18
   .WRITE_WIDTH_B(9),                                                                // 0-72
   // RSTREG_PRIORITY_A, RSTREG_PRIORITY_B: Reset or enable priority ("RSTREG" or "REGCE")
   .RSTREG_PRIORITY_A("RSTREG"),
   .RSTREG_PRIORITY_B("RSTREG"),
   // SRVAL_A, SRVAL_B: Set/reset value for output
   .SRVAL_A(18'h00000),
   .SRVAL_B(18'h00000),
   // Simulation Device: Must be set to "7SERIES" for simulation behavior
   .SIM_DEVICE("7SERIES"),
   // WriteMode: Value on output upon a write ("WRITE_FIRST", "READ_FIRST", or "NO_CHANGE")
   .WRITE_MODE_A("READ_FIRST"),
   .WRITE_MODE_B("READ_FIRST")
)
RAMB18E1_inst (
   // Port A Data: 16-bit (each) output: Port A data
   .DOADO(DOADO),                 // 16-bit output: A port data/LSB data
   .DOPADOP(DOPADOP),             // 2-bit output: A port parity/LSB parity
   // Port B Data: 16-bit (each) output: Port B data
   .DOBDO(DOBDO),                 // 16-bit output: B port data/MSB data
   .DOPBDOP(DOPBDOP),             // 2-bit output: B port parity/MSB parity
   // Port A Address/Control Signals: 14-bit (each) input: Port A address and control signals (read port
   // when RAM_MODE="SDP")
   .ADDRARDADDR(ADDRARDADDR),     // 14-bit input: A port address/Read address
   .CLKARDCLK(CKA),         // 1-bit input: A port clock/Read clock
   .ENARDEN(ENA),             // 1-bit input: A port enable/Read enable
   .REGCEAREGCE(CEA),     // 1-bit input: A port register enable/Register enable
   .RSTRAMARSTRAM(RSTA), // 1-bit input: A port set/reset
   .RSTREGARSTREG(RSTA), // 1-bit input: A port register set/reset
   .WEA(WEAX),                     // 2-bit input: A port write enable
   // Port A Data: 16-bit (each) input: Port A data
   .DIADI(DIADI),                 // 16-bit input: A port data/LSB data
   .DIPADIP(DIPADIP),             // 2-bit input: A port parity/LSB parity
   // Port B Address/Control Signals: 14-bit (each) input: Port B address and control signals (write port
   // when RAM_MODE="SDP")
   .ADDRBWRADDR(ADDRBWRADDR),     // 14-bit input: B port address/Write address
   .CLKBWRCLK(CKB),         // 1-bit input: B port clock/Write clock
   .ENBWREN(ENB),             // 1-bit input: B port enable/Write enable
   .REGCEB(CEB),               // 1-bit input: B port register enable
   .RSTRAMB(RSTB),             // 1-bit input: B port set/reset
   .RSTREGB(RSTB),             // 1-bit input: B port register set/reset
   .WEBWE(WEBX),                 // 4-bit input: B port write enable/Write enable
   // Port B Data: 16-bit (each) input: Port B data
   .DIBDI(DIBDI),                 // 16-bit input: B port data/MSB data
   .DIPBDIP(DIPBDIP)              // 2-bit input: B port parity/MSB parity
);

// End of RAMB18E1_inst instantiation
    assign WEAX[0]=WEA;
    assign WEAX[1]=WEA;
    assign WEBX[0]=WEB;
    assign WEBX[1]=WEB;
    assign WEBX[2]=WEB;
    assign WEBX[3]=WEB;

    assign  DOA[0]=DOADO[0];
    assign  DOA[1]=DOADO[1];
    assign  DOA[2]=DOADO[2];
    assign  DOA[3]=DOADO[3];
    assign  DOA[4]=DOADO[4];
    assign  DOA[5]=DOADO[5];
    assign  DOA[6]=DOADO[6];
    assign  DOA[7]=DOADO[7];

    assign DOB[0]=DOBDO[0];
    assign DOB[1]=DOBDO[1];
    assign DOB[2]=DOBDO[2];
    assign DOB[3]=DOBDO[3];
    assign DOB[4]=DOBDO[4];
    assign DOB[5]=DOBDO[5];
    assign DOB[6]=DOBDO[6];
    assign DOB[7]=DOBDO[7];

    assign  DIADI[0]=DIA[0];
    assign  DIADI[1]=DIA[1];
    assign  DIADI[2]=DIA[2];
    assign  DIADI[3]=DIA[3];
    assign  DIADI[4]=DIA[4];
    assign  DIADI[5]=DIA[5];
    assign  DIADI[6]=DIA[6];
    assign  DIADI[7]=DIA[7];

    assign  DIADI[8]=1'b0;
    assign  DIADI[9]=1'b0;
    assign  DIADI[10]=1'b0;
    assign  DIADI[11]=1'b0;
    assign  DIADI[12]=1'b0;
    assign  DIADI[13]=1'b0;
    assign  DIADI[14]=1'b0;
    assign  DIADI[15]=1'b0;

    assign  DIBDI[0]=DIB[0];
    assign  DIBDI[1]=DIB[1];
    assign  DIBDI[2]=DIB[2];
    assign  DIBDI[3]=DIB[3];
    assign  DIBDI[4]=DIB[4];
    assign  DIBDI[5]=DIB[5];
    assign  DIBDI[6]=DIB[6];
    assign  DIBDI[7]=DIB[7];

    assign  DIBDI[8]=1'b0;
    assign  DIBDI[9]=1'b0;
    assign  DIBDI[10]=1'b0;
    assign  DIBDI[11]=1'b0;
    assign  DIBDI[12]=1'b0;
    assign  DIBDI[13]=1'b0;
    assign  DIBDI[14]=1'b0;
    assign  DIBDI[15]=1'b0;

    assign  ADDRARDADDR[0]=1'b0;
    assign  ADDRARDADDR[1]=1'b0;
    assign  ADDRARDADDR[2]=1'b0;
    assign  ADDRARDADDR[3]=ADA[0];
    assign  ADDRARDADDR[4]=ADA[1];
    assign  ADDRARDADDR[5]=ADA[2];
    assign  ADDRARDADDR[6]=ADA[3];
    assign  ADDRARDADDR[7]=ADA[4];
    assign  ADDRARDADDR[8]=ADA[5];
    assign  ADDRARDADDR[9]=ADA[6];
    assign  ADDRARDADDR[10]=ADA[7];
    assign  ADDRARDADDR[11]=ADA[8];
    assign  ADDRARDADDR[12]=ADA[9];
    assign  ADDRARDADDR[13]=ADA[10];

    assign  ADDRBWRADDR[0]=1'b0;
    assign  ADDRBWRADDR[1]=1'b0;
    assign  ADDRBWRADDR[2]=1'b0;
    assign  ADDRBWRADDR[3]=ADB[0];
    assign  ADDRBWRADDR[4]=ADB[1];
    assign  ADDRBWRADDR[5]=ADB[2];
    assign  ADDRBWRADDR[6]=ADB[3];
    assign  ADDRBWRADDR[7]=ADB[4];
    assign  ADDRBWRADDR[8]=ADB[5];
    assign  ADDRBWRADDR[9]=ADB[6];
    assign  ADDRBWRADDR[10]=ADB[7];
    assign  ADDRBWRADDR[11]=ADB[8];
    assign  ADDRBWRADDR[12]=ADB[9];
    assign  ADDRBWRADDR[13]=ADB[10];

    assign  DIPADIP[0]=1'b0;
    assign  DIPADIP[1]=1'b0;
    assign  DIPBDIP[1]=1'b0;
    assign  DIPBDIP[0]=1'b0;
endmodule 
module BV_SD_SCOPE(WEEX,DTEX,ADEX,CLKEX,D,EXTRG1,EXTRG2,RXDI,PRAM1,PARM2,CMD,TX_TIMING,CLK,DOEX,ACQMD_ON,ADR,SPLCE,ACQ_RUN,DO,TX_STARTO);

	//Port List 
	input     WEEX;
	input     [15:0] DTEX;
	input     [10:0] ADEX;
	input     CLKEX;
	input     [7:0] D;
	input     EXTRG1;
	input     EXTRG2;
	input     [7:0] RXDI;
	input     PRAM1;
	input     PARM2;
	input     [3:0] CMD;
	input     TX_TIMING;
	input     CLK;
	output    [15:0] DOEX;
	output    ACQMD_ON;
	output    [10:0] ADR;
	output    SPLCE;
	output    ACQ_RUN;
	output    [7:0] DO;
	output    TX_STARTO;

	//Net List 
	wire      I188_O;
	wire      [10:0] I195_O;
	wire      VCC;
	wire      GND;
	wire      WE_1;
	wire      [7:0] I45_Q;
	wire      [7:0] I1_DOB;
	wire      WE_2;
	wire      [7:0] I49_O;
	wire      [7:0] I2_DOB;
	wire      [7:0] I16_O;
	wire      I145_SEL_BYTE;
	wire      CMD_AD;
	wire      I26_O;
	wire      STOP_READ;
	wire      I275_TX_TIMIMG;
	wire      CE_READ;
	wire      [7:0] I43_Q;
	wire      [7:0] I44_Q;
	wire      CLK_INV;
	wire      [7:0] I46_Q;
	wire      SPL_X2;
	wire      CMD_A9;
	wire      I134_TRGOUT;
	wire      I134_MODE7;
	wire      I134_MODE6;
	wire      CMD_AF;
	wire      I300_CE_RD;
	wire      ADRS_RST;
	wire      CMD_AA;
	wire      CMD_A8;
	wire      [7:0] I145_PHASEO;
	wire      I145_SPL12;
	wire      ABORT;
	wire      I144_CEO;
	wire      I212_O;
	wire      I165_ACQRUN_;
	wire      I164_ACQEND;
	wire      CMD_AB;
	wire      I264_AD;
	wire      I247_O;
	wire      [3:0] CMD_B;
	wire      I264_AC;
	wire      [7:0] DI;

	//Lower module connection 
	RAMB16_D8 Z1C0001(.WEA(I188_O),.DIA(DTEX[7:0]),.ADA(I195_O[10:0]),.ENA(VCC),.CKA(CLKEX),.RSTA(GND),.CEA(VCC),.WEB(WE_1),.DIB(I45_Q[7:0]),.ADB(ADR[10:0]),.ENB(VCC),.CKB(CLK),.RSTB(GND),.CEB(VCC),.DOA(DOEX[7:0]),.DOB(I1_DOB[7:0]));
	RAMB16_D8 Z1C0002(.WEA(I188_O),.DIA(DTEX[15:8]),.ADA(I195_O[10:0]),.ENA(VCC),.CKA(CLKEX),.RSTA(GND),.CEA(VCC),.WEB(WE_2),.DIB(I49_O[7:0]),.ADB(ADR[10:0]),.ENB(VCC),.CKB(CLK),.RSTB(GND),.CEB(VCC),.DOB(I2_DOB[7:0]));
	GND Z1C0007(.G(GND));
	VCC Z1C0008(.P(VCC));
	M2_1_8 Z1C0016(.A(I1_DOB[7:0]),.B(I2_DOB[7:0]),.O(I16_O[7:0]),.S0(I145_SEL_BYTE));
	BUF4 Z1C0021(.O(CMD_B[3:0]),.I(CMD[3:0]));
	INV Z1C0026(.I(CMD_AD),.O(I26_O));
	AND3B1 Z1C0028(.I0(STOP_READ),.I1(CMD_AD),.I2(I275_TX_TIMIMG),.O(CE_READ));
	FD8CE Z1C0043(.Q(I43_Q[7:0]),.D(DI[7:0]),.CLR(GND),.CE(VCC),.C(CLK));
	FD8CE Z1C0044(.Q(I44_Q[7:0]),.D(DI[7:0]),.CLR(GND),.CE(VCC),.C(CLK_INV));
	M2_1_8 Z1C0049(.A(I45_Q[7:0]),.B(I46_Q[7:0]),.O(I49_O[7:0]),.S0(SPL_X2));
	INV Z1C0055(.I(CLK),.O(CLK_INV));
	M2_1_8 Z1C0074(.A(I145_PHASEO[7:0]),.B(I16_O[7:0]),.O(DO[7:0]),.S0(CMD_AD));
	BUF Z1C0109(.I(D[0]),.O(DI[0]));
	BUF Z1C0110(.I(D[1]),.O(DI[1]));
	BUF Z1C0111(.I(D[2]),.O(DI[2]));
	BUF Z1C0112(.I(D[3]),.O(DI[3]));
	BUF Z1C0113(.I(D[4]),.O(DI[4]));
	BUF Z1C0114(.I(D[5]),.O(DI[5]));
	BV_SD_TRG Z1C0134(.D(D[7:0]),.EX1(EXTRG1),.EX2(EXTRG2),.RXDI(RXDI[7:0]),.CMDCE(CMD_A9),.PARAM1(PRAM1),.PARAM2(PARM2),.CLK(CLK),.TRGOUT(I134_TRGOUT),.MODE7(I134_MODE7),.MODE6(I134_MODE6),.CMD2(CMD_AF),.SMPLCE(SPLCE),.SPL2X(SPL_X2));
	BV_SD_SPCNT Z1C0145(.READ_CE(I300_CE_RD),.R_ADR(ADRS_RST),.TRGIN(I134_TRGOUT),.ACQ_MODE(CMD_AA),.CMDI(CMD_A8),.RXDI(RXDI[7:0]),.PRAM1(PRAM1),.PRAM2(PARM2),.CLK(CLK),.WE1(WE_1),.WE2(WE_2),.ADR(ADR[10:0]),.SPLX2_ACQ(SPL_X2),.SEL_BYTE(I145_SEL_BYTE),.ACQ_RUN(ACQ_RUN),.SPLCE(SPLCE),.PHASEO(I145_PHASEO[0]),.SPL12(I145_SPL12),.ACQMD_R(ABORT),.ACQMD_ON(ACQMD_ON));
	FDRE Z1C0149(.C(CLK),.CE(I144_CEO),.D(VCC),.Q(STOP_READ),.R(I26_O));
	defparam Z1C0149.INIT=1'b0;
	FD8CE Z1C0153(.Q(I46_Q[7:0]),.D(I44_Q[7:0]),.CLR(GND),.CE(VCC),.C(CLK));
	CB12RE Z1C0155(.C(CLK),.R(I26_O),.CE(CE_READ),.CEO(I144_CEO));
	M2_1 Z1C0158(.D0(I212_O),.D1(CE_READ),.O(TX_STARTO),.S0(CMD_AD));
	ONESHOT_D1 Z1C0164(.I(I165_ACQRUN_),.CK(CLK),.Q(I164_ACQEND));
	INV Z1C0165(.I(ACQ_RUN),.O(I165_ACQRUN_));
	AND2 Z1C0188(.I0(CMD_AB),.I1(WEEX),.O(I188_O));
	BUF11 Z1C0195(.O(I195_O[10:0]),.I(ADEX[10:0]));
	ONESHOT_D1 Z1C0204(.I(CMD_AB),.CK(CLK),.Q(ADRS_RST));
	FDCE Z1C0208(.C(CLK),.CE(I275_TX_TIMIMG),.CLR(GND),.D(I264_AD),.Q(CMD_AD));
	defparam Z1C0208.INIT=1'b0;
	AND2 Z1C0212(.I0(ACQMD_ON),.I1(I164_ACQEND),.O(I212_O));
	BV_SD_ANIT8 Z1C0237(.IN(DI[7:0]),.DLY(I43_Q[7:0]),.CE(SPLCE),.CLK(CLK),.O(I45_Q[7:0]),.EN(I247_O),.SPL2X(SPL_X2));
	AND2B1 Z1C0247(.O(I247_O),.I1(I134_MODE6),.I0(I145_SPL12));
	BV_ADDEC8 Z1C0264(.A0(CMD_B[0]),.A1(CMD_B[1]),.A2(CMD_B[2]),.E1(CMD_B[3]),.E2(VCC),.CLK(CLK),.Q0(CMD_A8),.Q1(CMD_A9),.Q2(CMD_AA),.Q3(CMD_AB),.Q4(I264_AC),.Q5(I264_AD),.Q7(CMD_AF));
	GN5 Z1C0273(.G(I145_PHASEO[7:3]));
	GN2 Z1C0274(.G(I145_PHASEO[2:1]));
	ONESHOT_D1 Z1C0275(.I(TX_TIMING),.CK(CLK),.Q(I275_TX_TIMIMG));
	OR3 Z1C0280(.I0(I264_AD),.I1(I264_AC),.I2(CMD_AB),.O(ABORT));
	M2_1 Z1C0283(.D0(D[6]),.D1(EXTRG1),.O(DI[6]),.S0(I134_MODE7));
	M2_1 Z1C0284(.D0(D[7]),.D1(EXTRG2),.O(DI[7]),.S0(I134_MODE7));
	DLY3 Z1C0300(.D(CE_READ),.CK(CLK),.Q2(I300_CE_RD));
endmodule 
///////////////////////////////////////////////////////////////////////////////

`timescale  100 ps / 10 ps

module BIT_DN8 (O, I);
    

   output [7:0] O;

   input  [7:0] I;


assign O[0] = I[1];
assign O[1] = I[2];
assign O[2] = I[3];
assign O[3] = I[4];
assign O[4] = I[5];
assign O[5] = I[6];
assign O[6] = I[7];
assign O[7] = 1'b0;

endmodule
module BV_SWAP(I,O);

	//Port List 
	input     [7:0] I;
	output    [7:0] O;

	//Net List 
	wire      [7:0] I9_O;
	wire      [7:0] XI10_I;

	//Lower module connection 
	BUF Z1C0001(.I(I9_O[0]),.O(XI10_I[7]));
	BUF Z1C0002(.I(I9_O[1]),.O(XI10_I[6]));
	BUF Z1C0003(.I(I9_O[2]),.O(XI10_I[5]));
	BUF Z1C0004(.I(I9_O[3]),.O(XI10_I[4]));
	BUF Z1C0005(.I(I9_O[4]),.O(XI10_I[3]));
	BUF Z1C0006(.I(I9_O[5]),.O(XI10_I[2]));
	BUF Z1C0007(.I(I9_O[6]),.O(XI10_I[1]));
	BUF Z1C0008(.I(I9_O[7]),.O(XI10_I[0]));
	BUF8 Z1C0009(.I(I[7:0]),.O(I9_O[7:0]));
	BUF8 Z1C0010(.I(XI10_I[7:0]),.O(O[7:0]));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       4-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB4RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB4RE(CEO, Q0, Q1, Q2, Q3, TC, C, CE, R);
   
   parameter TERMINAL_COUNT = 4'b1111;
   
   output             CEO;
   output             Q0;
   output             Q1;
   output             Q2;
   output             Q3;
   output             TC;
   
   input 	      C;	
   input 	      CE;	
   input 	      R;	
   
   reg                Q0;
   reg                Q1;
   reg                Q2;
   reg                Q3;
   
   always @(posedge C)
     begin
	if (R)
	  {Q3, Q2, Q1, Q0} <= 4'b0000;
	else if (CE)
	  {Q3,Q2,Q1,Q0} <= {Q3,Q2,Q1,Q0} + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = R ? 1'b0 : ({Q3,Q2,Q1,Q0} == TERMINAL_COUNT); 
   
endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library 
//  /   /                       8-Bit Cascadable Binary Counter with Clock Enable and Synchronous Reset
// /___/   /\     Filename    : CB8RE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB4RE_BUS(CEO, Q, TC, C, CE, R);
   
   parameter TERMINAL_COUNT = 4'b1111;
   
   output             CEO;
   output [3:0]       Q;
   output             TC;
   
   input 	      C;	
   input 	      CE;	
   input 	      R;	
   
   reg   [3:0]        Q;
   
   always @(posedge C)
     begin
	if (R)
	  Q <= 4'b0000;
	else if (CE)
	  Q <= Q + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = R ? 1'b0 : (Q == TERMINAL_COUNT); 
   
endmodule
///////////////////////////////////////////////////////////////////////////////

`timescale  100 ps / 10 ps

module BUF10 (O, I);
    

   output [9:0] O;

   input  [9:0] I;


assign O = I;

endmodule
module CONST0_8(V);

	//Port List 
	output    [7:0] V;

      assign  V = 8'b00000000;

endmodule 
module GN10(G);

	//Port List 
	output    [9:0] G;

	//Net List 
	wire      [9:0] I7_V;

	//Lower module connection 
	GND Z1C0003(.G(I7_V[1]));
	GND Z1C0004(.G(I7_V[0]));
	BUF10 Z1C0006(.O(G[9:0]),.I(I7_V[9:0]));
	CONST0_8 Z1C0007(.V(I7_V[9:2]));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       16-Bit Loadable Serial/Parallel-In Parallel-Out Shift Register with Clock Enable and Asynchronous Clear
// /___/   /\     Filename    : SR16CLE.v
// \   \  /  \    Timestamp   : Fri Jul 21 2006
//  \___\/\___\
//
// Revision:
//    07/21/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module SR10CLE(Q, C, CE, CLR, D, L, SLI) ;
  
   
   output [9:0]      Q;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   input  [9:0]      D;
   input              L;
   input              SLI;
   
   reg    [9:0]      Q;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  Q <= 10'b00_0000_0000;
        else if (L)
           Q <= D;
	else if (CE)
          Q <= {Q[8:0], SLI};
     end
   
   
endmodule
module BV_SERIAL8(TBUS,TX_START,BOAURATE,RXI,CLK,TXO,TX_RUNO,TIMINGO,TX_BAU,RXDO,RX_OK,RX_BUSY,TIMEOUT);

	//Port List 
	input     [7:0] TBUS;
	input     TX_START;
	input     [7:0] BOAURATE;
	input     RXI;
	input     CLK;
	output    TXO;
	output    TX_RUNO;
	output    TIMINGO;
	output    TX_BAU;
	output    [7:0] RXDO;
	output    RX_OK;
	output    RX_BUSY;
	output    TIMEOUT;

	//Net List 
	wire      VCC;
	wire      TX_ST;
	wire      I21_O;
	wire      GND;
	wire      [9:0] XI1_D;
	wire      I32_O;
	wire      I18_Q0;
	wire      I18_Q1;
	wire      I18_Q2;
	wire      I18_Q3;
	wire      TX_CE;
	wire      I36_O;
	wire      I72_O;
	wire      [7:0] I43_Q;
	wire      I44_EQ;
	wire      I53_Q;
	wire      I54_Q;
	wire      I93_Q1;
	wire      [9:0] I63_G;
	wire      RX_CE2;
	wire      [9:0] I58_Q;
	wire      [7:0] I122_O;
	wire      I127_Q2;
	wire      [7:0] I136_Q;
	wire      [9:0] I1_Q;
	wire      [3:0] I84_Q;
	wire      I93_Q2;
	wire      BOTHEDGE;
	wire      [7:0] I98_Q;
	wire      I103_O;
	wire      I101_EQ;
	wire      [7:0] I107_O;
	wire      RX_CE;
	wire      NEGEDGE;
	wire      I125_O;
	wire      I120_O;
	wire      [3:0] I112_Q;
	wire      I127_Q1;
	wire      I132_O;

	//Lower module connection 
	SR10CLE Z1C0001(.SLI(VCC),.D(XI1_D[9:0]),.L(TX_ST),.CE(I21_O),.C(CLK),.CLR(GND),.Q(I1_Q[9:0]));
	BUF Z1C0003(.I(VCC),.O(XI1_D[0]));
	BUF Z1C0004(.I(GND),.O(XI1_D[9]));
	GND Z1C0005(.G(GND));
	VCC Z1C0006(.P(VCC));
	CB4RE Z1C0018(.CE(I32_O),.Q0(I18_Q0),.Q1(I18_Q1),.Q2(I18_Q2),.Q3(I18_Q3),.C(CLK),.R(TX_ST));
	AND2 Z1C0021(.I0(TX_RUNO),.I1(TX_CE),.O(I21_O));
	AND2B1 Z1C0032(.O(I32_O),.I1(TX_CE),.I0(I36_O));
	FDRE Z1C0035(.C(CLK),.CE(I72_O),.D(VCC),.Q(TX_RUNO),.R(I36_O));
	defparam Z1C0035.INIT=1'b0;
	AND2 Z1C0036(.I0(I18_Q3),.I1(I18_Q0),.O(I36_O));
	CB8RE Z1C0043(.Q(I43_Q[7:0]),.C(CLK),.R(I44_EQ),.CE(VCC));
	COMP8 Z1C0044(.B(BOAURATE[7:0]),.A(I43_Q[7:0]),.EQ(I44_EQ));
	FDRE Z1C0053(.C(CLK),.CE(TX_START),.D(VCC),.Q(I53_Q),.R(I54_Q));
	defparam Z1C0053.INIT=1'b0;
	FDRE Z1C0054(.C(CLK),.CE(TX_CE),.D(I53_Q),.Q(I54_Q),.R(GND));
	defparam Z1C0054.INIT=1'b0;
	SR10CLE Z1C0058(.SLI(I93_Q1),.D(I63_G[9:0]),.L(GND),.CE(RX_CE2),.C(CLK),.CLR(GND),.Q(I58_Q[9:0]));
	FD8CE Z1C0061(.Q(RXDO[7:0]),.D(I122_O[7:0]),.CLR(GND),.CE(I127_Q2),.C(CLK));
	GN10 Z1C0063(.G(I63_G[9:0]));
	AND2 Z1C0065(.I0(I36_O),.I1(I54_Q),.O(TX_ST));
	FD Z1C0067(.Q(TX_CE),.D(I44_EQ),.C(CLK));
	defparam Z1C0067.INIT=1'b0;
	BUF Z1C0070(.I(TX_CE),.O(TX_BAU));
	AND4B4 Z1C0072(.I0(I18_Q3),.I1(I18_Q2),.I2(I18_Q1),.I3(I18_Q0),.O(I72_O));
	BV_SWAP Z1C0080(.I(I136_Q[7:0]),.O(XI1_D[8:1]));
	BUF Z1C0083(.I(I1_Q[9]),.O(TXO));
	CB4RE_BUS Z1C0084(.Q(I84_Q[3:0]),.C(CLK),.R(TIMINGO),.CE(TX_CE));
	AND3 Z1C0086(.I0(TX_CE),.I1(I84_Q[3]),.I2(I84_Q[0]),.O(TIMINGO));
	XOR2 Z1C0091(.I0(I93_Q2),.I1(I93_Q1),.O(BOTHEDGE));
	DLY3 Z1C0093(.D(RXI),.CK(CLK),.Q2(I93_Q2),.Q1(I93_Q1));
	CB8RE Z1C0098(.Q(I98_Q[7:0]),.C(CLK),.R(I103_O),.CE(VCC));
	COMP8 Z1C0101(.B(BOAURATE[7:0]),.A(I98_Q[7:0]),.EQ(I101_EQ));
	OR2 Z1C0103(.I0(I101_EQ),.I1(BOTHEDGE),.O(I103_O));
	COMP8 Z1C0106(.B(I107_O[7:0]),.A(I98_Q[7:0]),.EQ(RX_CE));
	BIT_DN8 Z1C0107(.O(I107_O[7:0]),.I(BOAURATE[7:0]));
	AND2B1 Z1C0110(.O(NEGEDGE),.I1(I93_Q2),.I0(I93_Q1));
	CB4RE_BUS Z1C0112(.Q(I112_Q[3:0]),.C(CLK),.R(I125_O),.CE(RX_CE2));
	FDRE Z1C0113(.C(CLK),.CE(NEGEDGE),.D(VCC),.Q(RX_BUSY),.R(I120_O));
	defparam Z1C0113.INIT=1'b0;
	AND2 Z1C0115(.I0(RX_CE),.I1(RX_BUSY),.O(RX_CE2));
	AND2 Z1C0120(.I0(I112_Q[0]),.I1(I112_Q[3]),.O(I120_O));
	BV_SWAP Z1C0122(.I(I58_Q[7:0]),.O(I122_O[7:0]));
	AND2 Z1C0125(.I0(I120_O),.I1(RX_CE),.O(I125_O));
	DLY3 Z1C0127(.D(I120_O),.CK(CLK),.Q3(RX_OK),.Q2(I127_Q2),.Q1(I127_Q1));
	CB2RE Z1C0131(.TC(TIMEOUT),.CE(I132_O),.C(CLK),.R(I127_Q1));
	AND2B1 Z1C0132(.O(I132_O),.I1(TIMINGO),.I0(TIMEOUT));
	FD8CE Z1C0136(.Q(I136_Q[7:0]),.D(TBUS[7:0]),.CLR(GND),.CE(TX_START),.C(CLK));
endmodule 
module CONST0(V);

	//Port List 
	output    [3:0] V;

      assign  V = 4'b0000;

endmodule 
module BV_SDEBUG(RXI,TXDI,TXST,B_RATE,CLK_COM,VAL_A,VAL_B,WEEX,DTEX,ADEX,CLKEX,D0,D1,D2,D3,D4,D5,D6,D7,EXTRG1,EXTRG2,CLK,TXO,RXDO,RXOK,TIMEOUT,LOBYTE,HIBYTE,DOEX,CMDCE,CMD,PRAM1,PRAM2,SCP_ADR,SPLCE,ACQMD_ON,ACQ_RUN);

	//Port List 
	input     RXI;
	input     [7:0] TXDI;
	input     TXST;
	input     [7:0] B_RATE;
	input     CLK_COM;
	input     [7:0] VAL_A;
	input     [7:0] VAL_B;
	input     WEEX;
	input     [15:0] DTEX;
	input     [10:0] ADEX;
	input     CLKEX;
	input     D0;
	input     D1;
	input     D2;
	input     D3;
	input     D4;
	input     D5;
	input     D6;
	input     D7;
	input     EXTRG1;
	input     EXTRG2;
	input     CLK;
	output    TXO;
	output    [7:0] RXDO;
	output    RXOK;
	output    TIMEOUT;
	output    [7:0] LOBYTE;
	output    [7:0] HIBYTE;
	output    [15:0] DOEX;
	output    CMDCE;
	output    [3:0] CMD;
	output    PRAM1;
	output    PRAM2;
	output    [10:0] SCP_ADR;
	output    SPLCE;
	output    ACQMD_ON;
	output    ACQ_RUN;

	//Net List 
	wire      [7:0] I74_O;
	wire      I75_O;
	wire      I1_TIMINGO;
	wire      I1_RX_OK;
	wire      I1_TIMEOUT;
	wire      I18_CMD_CEO;
	wire      I18_PRM1_CEO;
	wire      I18_PRM2_CEO;
	wire      I18_CMD_YES;
	wire      CMD_0;
	wire      CMD4_7;
	wire      SCP_TXST;
	wire      I27_TXSTART;
	wire      I86_AQS_USE;
	wire      [7:0] I92_O;
	wire      [7:0] SCOPED;
	wire      [7:0] I28_O;
	wire      [7:0] I31_O;
	wire      I89_DBUG_USE;
	wire      I114_O;
	wire      I83_Q3;
	wire      [7:0] I94_V;
	wire      [3:0] I18_CMDO;
	wire      [7:0] XI38_D;
	wire      I115_Q;

	//Lower module connection 
	BV_SERIAL8 Z1C0001(.TBUS(I74_O[7:0]),.TX_START(I75_O),.BOAURATE(B_RATE[7:0]),.RXI(RXI),.CLK(CLK_COM),.TXO(TXO),.TIMINGO(I1_TIMINGO),.RXDO(RXDO[7:0]),.RX_OK(I1_RX_OK),.TIMEOUT(I1_TIMEOUT));
	BV_SD_CMDEC Z1C0018(.RXD(RXDO[7:0]),.RX_OK(I1_RX_OK),.TIMEOUT(I1_TIMEOUT),.CLK(CLK),.CMDO(I18_CMDO[3:0]),.CMD_CEO(I18_CMD_CEO),.PRM1_CEO(I18_PRM1_CEO),.PRM2_CEO(I18_PRM2_CEO),.CMD_YES(I18_CMD_YES));
	BV_SD_PINOUT Z1C0021(.RXDI(RXDO[7:0]),.CMND(CMD_0),.PRM2(I18_PRM2_CEO),.PRM1(I18_PRM1_CEO),.CLK(CLK),.LOBYTE(LOBYTE[7:0]),.HIBYTE(HIBYTE[7:0]));
	AND4B4 Z1C0024(.I0(I18_CMDO[3]),.I1(I18_CMDO[2]),.I2(I18_CMDO[1]),.I3(I18_CMDO[0]),.O(CMD_0));
	M2_1 Z1C0027(.D0(CMD4_7),.D1(SCP_TXST),.O(I27_TXSTART),.S0(I86_AQS_USE));
	M2_1_8 Z1C0028(.A(I92_O[7:0]),.B(SCOPED[7:0]),.O(I28_O[7:0]),.S0(I86_AQS_USE));
	M2_1_8 Z1C0031(.A(VAL_A[7:0]),.B(VAL_B[7:0]),.O(I31_O[7:0]),.S0(I18_CMDO[0]));
	BV_SD_SCOPE Z1C0038(.D(XI38_D[7:0]),.EXTRG1(EXTRG1),.EXTRG2(EXTRG2),.RXDI(RXDO[7:0]),.PRAM1(I18_PRM1_CEO),.PARM2(I18_PRM2_CEO),.CMD(I18_CMDO[3:0]),.TX_TIMING(I1_TIMINGO),.CLK(CLK),.DO(SCOPED[7:0]),.TX_STARTO(SCP_TXST),.SPLCE(SPLCE),.ACQ_RUN(ACQ_RUN),.ADR(SCP_ADR[10:0]),.ACQMD_ON(ACQMD_ON),.ADEX(ADEX[10:0]),.DTEX(DTEX[15:0]),.WEEX(WEEX),.CLKEX(CLKEX),.DOEX(DOEX[15:0]));
	BUF4 Z1C0054(.O(CMD[3:0]),.I(I18_CMDO[3:0]));
	BUF Z1C0055(.I(I1_TIMEOUT),.O(TIMEOUT));
	BUF Z1C0056(.I(I18_PRM1_CEO),.O(PRAM1));
	BUF Z1C0057(.I(I18_PRM2_CEO),.O(PRAM2));
	BUF Z1C0062(.I(I18_CMD_CEO),.O(CMDCE));
	M2_1_8 Z1C0074(.A(TXDI[7:0]),.B(I28_O[7:0]),.O(I74_O[7:0]),.S0(I89_DBUG_USE));
	M2_1 Z1C0075(.D0(TXST),.D1(I114_O),.O(I75_O),.S0(I89_DBUG_USE));
	AND2B1 Z1C0081(.O(RXOK),.I1(I83_Q3),.I0(I18_CMD_YES));
	DLY3 Z1C0083(.D(I1_RX_OK),.CK(CLK),.Q3(I83_Q3));
	OR2 Z1C0086(.I0(ACQMD_ON),.I1(I18_CMDO[3]),.O(I86_AQS_USE));
	OR2 Z1C0089(.I0(ACQMD_ON),.I1(I18_CMD_YES),.O(I89_DBUG_USE));
	AND3B1 Z1C0091(.I0(I18_CMDO[3]),.I1(I18_CMDO[2]),.I2(I18_CMD_CEO),.O(CMD4_7));
	M2_1_8 Z1C0092(.A(I31_O[7:0]),.B(I94_V[7:0]),.O(I92_O[7:0]),.S0(I18_CMDO[1]));
	CONST0 Z1C0094(.V(I94_V[3:0]));
	CONST0 Z1C0095(.V(I94_V[7:4]));
	BUF Z1C0098(.I(D0),.O(XI38_D[0]));
	BUF Z1C0099(.I(D1),.O(XI38_D[1]));
	BUF Z1C0100(.I(D2),.O(XI38_D[2]));
	BUF Z1C0101(.I(D3),.O(XI38_D[3]));
	BUF Z1C0102(.I(D4),.O(XI38_D[4]));
	BUF Z1C0103(.I(D5),.O(XI38_D[5]));
	BUF Z1C0104(.I(D6),.O(XI38_D[6]));
	BUF Z1C0105(.I(D7),.O(XI38_D[7]));
	OR2 Z1C0114(.I0(I115_Q),.I1(I27_TXSTART),.O(I114_O));
	FD Z1C0115(.Q(I115_Q),.D(I27_TXSTART),.C(CLK));
	defparam Z1C0115.INIT=1'b0;
endmodule 
module BV_SYNCPLS(I,CLKIN,CLKOUT,O);

	//Port List 
	input     I;
	input     CLKIN;
	input     CLKOUT;
	output    O;

	//Net List 
	wire      VCC;
	wire      I1_Q;
	wire      I3_RESET;
	wire      I16_Q;
	wire      I2_Q;
	wire      GND;

	//Lower module connection 
	FDRE Z1C0001(.C(CLKIN),.CE(I),.D(VCC),.Q(I1_Q),.R(I3_RESET));
	defparam Z1C0001.INIT=1'b0;
	FDRE Z1C0002(.C(CLKOUT),.CE(VCC),.D(I16_Q),.Q(I2_Q),.R(GND));
	defparam Z1C0002.INIT=1'b0;
	FDRE Z1C0003(.C(CLKIN),.CE(VCC),.D(I16_Q),.Q(I3_RESET),.R(I3_RESET));
	defparam Z1C0003.INIT=1'b0;
	VCC Z1C0008(.P(VCC));
	FDRE Z1C0016(.C(CLKOUT),.CE(VCC),.D(I1_Q),.Q(I16_Q),.R(I3_RESET));
	defparam Z1C0016.INIT=1'b0;
	GND Z1C0020(.G(GND));
	AND2B1 Z1C0022(.O(O),.I1(I16_Q),.I0(I2_Q));
endmodule 
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       16-Bit Cascadable Binary Counter with Clock Enable and Asynchronous Clear
// /___/   /\     Filename    : CB16CE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB16CE(CEO, Q, TC, C, CE, CLR);
   
   parameter TERMINAL_COUNT = 16'b1111_1111_1111_1111;
   
   output             CEO;
   output [15:0]      Q;
   output             TC;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   
   reg    [15:0]      Q;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  Q <= 16'b0000_0000_0000_0000;
	else if (CE)
	  Q <= Q + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = CLR ? 1'b0 : (Q == TERMINAL_COUNT);
   
endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       2-Bit Cascadable Binary Counter with Clock Enable and Asynchronous Clear
// /___/   /\     Filename    : CB2CE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB2CE(CEO, Q0, Q1, TC, C, CE, CLR);
   
   parameter TERMINAL_COUNT = 2'b11;
   
   output             CEO;
   output             Q0;
   output             Q1;
   output             TC;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   
   reg                Q0;
   reg                Q1;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  {Q1, Q0} <= 2'b00;
	else if (CE)
	  {Q1,Q0} <= {Q1,Q0} + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = CLR ? 1'b0 : ({Q1,Q0} == TERMINAL_COUNT);
   
endmodule
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2006 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor      : Xilinx
// \   \   \/     Version     : Jade (J.23)
//  \   \         Description : Xilinx HDL Macro Library
//  /   /                       8-Bit Cascadable Binary Counter with Clock Enable and Asynchronous Clear
// /___/   /\     Filename    : CB8CE.v
// \   \  /  \    Timestamp   : Tue Jul 25 2006
//  \___\/\___\
//
// Revision:
//    07/25/06 - Initial version.
// End Revision

`timescale 100 ps / 10 ps

module CB8CE(CEO, Q, TC, C, CE, CLR);
   
   parameter TERMINAL_COUNT = 8'b1111_1111;
   
   output             CEO;
   output [7:0]       Q;
   output             TC;

   input 	      C;	
   input 	      CE;	
   input 	      CLR;	
   
   reg   [7:0]        Q;
   
   always @(posedge C or posedge CLR)
     begin
	if (CLR)
	  Q <= 8'b0000_0000;
	else if (CE)
	  Q <= Q + 1;
     end
   
   assign CEO = TC & CE;
   assign TC = CLR ? 1'b0 : (Q == TERMINAL_COUNT);
   
endmodule
module CONST1(V);

	//Port List 
	output    [3:0] V;

      assign  V = 4'b0001;

endmodule 
module CONST3(V);

	//Port List 
	output    [3:0] V;

      assign  V = 4'b0011;

endmodule 
module MMCME2_BASE_12M_50X (CLKOUT0,CLKOUT0B,CLKOUT1,CLKOUT1B,CLKOUT2,CLKOUT2B,CLKOUT3,CLKOUT3B,CLKOUT4,CLKOUT5,CLKOUT6,CLKFBOUT,CLKFBOUTB,LOCKED,CLKIN1,PWRDWN,RST,CLKFBIN);
    output    CLKOUT0;
    output    CLKOUT0B;
    output    CLKOUT1;
    output    CLKOUT1B;
    output    CLKOUT2;
    output    CLKOUT2B;
    output    CLKOUT3;
    output    CLKOUT3B;
    output    CLKOUT4;
    output    CLKOUT5;
    output    CLKOUT6;
    output    CLKFBOUT;
    output    CLKFBOUTB;
    output    LOCKED;
    input    CLKIN1;
    input    PWRDWN;
    input    RST;
    input    CLKFBIN;

// MMCME2_BASE: Base Mixed Mode Clock Manager
//              7 Series
// Xilinx HDL Language Template, version 2020.2

MMCME2_BASE #(
   .BANDWIDTH("OPTIMIZED"),   // Jitter programming (OPTIMIZED, HIGH, LOW)
   .CLKFBOUT_MULT_F(50.0),     // Multiply value for all CLKOUT (2.000-64.000).
   .CLKFBOUT_PHASE(0.0),      // Phase offset in degrees of CLKFB (-360.000-360.000).
   .CLKIN1_PERIOD(83.333),       // Input clock period in ns to ps resolution (i.e. 33.333 is 30 MHz).
   // CLKOUT0_DIVIDE - CLKOUT6_DIVIDE: Divide amount for each CLKOUT (1-128)
   .CLKOUT1_DIVIDE(2), //300Mhz
   .CLKOUT2_DIVIDE(3), //200Mhz
   .CLKOUT3_DIVIDE(4), //150Mhz
   .CLKOUT4_DIVIDE(5), //120Mhz
   .CLKOUT5_DIVIDE(6), //100Mhz
   .CLKOUT6_DIVIDE(8), //75Mhz
   .CLKOUT0_DIVIDE_F(10.0),    // Divide amount for CLKOUT0 (1.000-128.000). //60Mhz
   // CLKOUT0_DUTY_CYCLE - CLKOUT6_DUTY_CYCLE: Duty cycle for each CLKOUT (0.01-0.99).
   .CLKOUT0_DUTY_CYCLE(0.5),
   .CLKOUT1_DUTY_CYCLE(0.5),
   .CLKOUT2_DUTY_CYCLE(0.5),
   .CLKOUT3_DUTY_CYCLE(0.5),
   .CLKOUT4_DUTY_CYCLE(0.5),
   .CLKOUT5_DUTY_CYCLE(0.5),
   .CLKOUT6_DUTY_CYCLE(0.5),
   // CLKOUT0_PHASE - CLKOUT6_PHASE: Phase offset for each CLKOUT (-360.000-360.000).
   .CLKOUT0_PHASE(0.0),
   .CLKOUT1_PHASE(0.0),
   .CLKOUT2_PHASE(0.0),
   .CLKOUT3_PHASE(0.0),
   .CLKOUT4_PHASE(0.0),
   .CLKOUT5_PHASE(0.0),
   .CLKOUT6_PHASE(0.0),
   .CLKOUT4_CASCADE("FALSE"), // Cascade CLKOUT4 counter with CLKOUT6 (FALSE, TRUE)
   .DIVCLK_DIVIDE(1),         // Master division value (1-106)
   .REF_JITTER1(0.0),         // Reference input jitter in UI (0.000-0.999).
   .STARTUP_WAIT("FALSE")     // Delays DONE until MMCM is locked (FALSE, TRUE)
)
MMCME2_BASE_inst (
   // Clock Outputs: 1-bit (each) output: User configurable clock outputs
   .CLKOUT0(CLKOUT0),     // 1-bit output: CLKOUT0
   .CLKOUT0B(CLKOUT0B),   // 1-bit output: Inverted CLKOUT0
   .CLKOUT1(CLKOUT1),     // 1-bit output: CLKOUT1
   .CLKOUT1B(CLKOUT1B),   // 1-bit output: Inverted CLKOUT1
   .CLKOUT2(CLKOUT2),     // 1-bit output: CLKOUT2
   .CLKOUT2B(CLKOUT2B),   // 1-bit output: Inverted CLKOUT2
   .CLKOUT3(CLKOUT3),     // 1-bit output: CLKOUT3
   .CLKOUT3B(CLKOUT3B),   // 1-bit output: Inverted CLKOUT3
   .CLKOUT4(CLKOUT4),     // 1-bit output: CLKOUT4
   .CLKOUT5(CLKOUT5),     // 1-bit output: CLKOUT5
   .CLKOUT6(CLKOUT6),     // 1-bit output: CLKOUT6
   // Feedback Clocks: 1-bit (each) output: Clock feedback ports
   .CLKFBOUT(CLKFBOUT),   // 1-bit output: Feedback clock
   .CLKFBOUTB(CLKFBOUTB), // 1-bit output: Inverted CLKFBOUT
   // Status Ports: 1-bit (each) output: MMCM status ports
   .LOCKED(LOCKED),       // 1-bit output: LOCK
   // Clock Inputs: 1-bit (each) input: Clock input
   .CLKIN1(CLKIN1),       // 1-bit input: Clock
   // Control Ports: 1-bit (each) input: MMCM control ports
   .PWRDWN(PWRDWN),       // 1-bit input: Power-down
   .RST(RST),             // 1-bit input: Reset
   // Feedback Clocks: 1-bit (each) input: Clock feedback ports
   .CLKFBIN(CLKFBIN)      // 1-bit input: Feedback clock
);

// End of MMCME2_BASE_inst instantiation

endmodule
